/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.subscriber.EventConsumer;
import be.looorent.jflu.subscriber.EventMapping;
import be.looorent.jflu.subscriber.Subscription;
import be.looorent.jflu.subscriber.SubscriptionQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionScanner {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionScanner.class);

    public Collection<Subscription> findAllSubscriptionsIn(String packagePrefix) {
        if (packagePrefix == null || packagePrefix.isEmpty()) {
            throw new IllegalArgumentException("packagePrefix must not be null");
        }
        Reflections reflections = new Reflections(packagePrefix, new Scanner[0]);
        return reflections.getSubTypesOf(EventConsumer.class).stream().map(this::createSubscriber).filter(Optional::isPresent).map(Optional::get).map(this::findAllProjectionsMethods).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<Subscription> findAllProjectionsMethods(EventConsumer subscriber) {
        return Arrays.stream(subscriber.getClass().getMethods()).filter(method -> method.isAnnotationPresent(EventMapping.class)).map(method -> this.createSubscription(subscriber, (Method)method)).collect(Collectors.toList());
    }

    protected Subscription createSubscription(EventConsumer subscriber, Method method) {
        String name = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        SubscriptionQuery query = new SubscriptionQuery(method.getAnnotation(EventMapping.class));
        method.setAccessible(true);
        return new Subscription(query, name, event -> {
            try {
                method.invoke((Object)subscriber, event);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("This subscriber cannot be called.", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOG.error("An error occurred when processing this event: {}", (Object)event.getId(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    protected Optional<EventConsumer> createSubscriber(Class<? extends EventConsumer> type) {
        try {
            Constructor<? extends EventConsumer> constructor = type.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return Optional.of(constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            LOG.error("EventConsumer must have a default constructor: {}", type, (Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("Impossible to create an instance of this type: {}", type, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

