/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.EventData;
import be.looorent.jflu.Payload;
import be.looorent.jflu.entity.EntityActionName;
import be.looorent.jflu.entity.EntityChange;
import be.looorent.jflu.entity.EventSerializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class EntityData
implements EventData {
    @JsonDeserialize(using=EventSerializer.IdDeserializer.class)
    private final Object id;
    private final UUID requestId;
    private final String entityName;
    private final EntityActionName actionName;
    private final Map<String, Payload> userMetadata;
    private final Map<String, Object> associations;
    private final Map<String, EntityChange> changes;
    @JsonIgnore
    private final Map<String, Long> associationIds;
    @JsonIgnore
    private final Map<String, String> associationTypes;

    @JsonCreator
    public EntityData(@JsonProperty(value="entityId") Object id, @JsonProperty(value="requestId") UUID requestId, @JsonProperty(value="entityName") String entityName, @JsonProperty(value="actionName") EntityActionName actionName, @JsonProperty(value="userMetadata") Map<String, Payload> userMetadata, @JsonProperty(value="associations") Map<String, Object> associations, @JsonProperty(value="changes") Map<String, EntityChange> changes) {
        this.id = id;
        this.requestId = requestId;
        this.entityName = entityName;
        this.actionName = actionName;
        this.userMetadata = Optional.ofNullable(userMetadata).orElseGet(Collections::emptyMap);
        this.associations = Optional.ofNullable(associations).orElseGet(Collections::emptyMap);
        this.changes = changes;
        this.associationIds = this.associations.entrySet().stream().filter(x$0 -> Association.isIdEntry(x$0)).collect(Collectors.toMap(Map.Entry::getKey, x$0 -> Association.castAssociationId(x$0)));
        this.associationTypes = this.associations.entrySet().stream().filter(x$0 -> Association.isTypeEntry(x$0)).collect(Collectors.toMap(Map.Entry::getKey, x$0 -> Association.castAssociationType(x$0)));
    }

    public Object getId() {
        return this.id;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public EntityActionName getActionName() {
        return this.actionName;
    }

    public Map<String, Payload> getUserMetadata() {
        return this.userMetadata;
    }

    public Map<String, Object> getAssociations() {
        return Collections.unmodifiableMap(this.associations);
    }

    public Map<String, Long> getAssociationIds() {
        return Collections.unmodifiableMap(this.associationIds);
    }

    public Map<String, String> getAssociationTypes() {
        return Collections.unmodifiableMap(this.associationTypes);
    }

    public Map<String, EntityChange> getChanges() {
        return this.changes;
    }

    private static class Association {
        private Association() {
        }

        private static Long castAssociationId(Map.Entry<String, Object> entry) {
            return Optional.ofNullable(entry.getValue()).filter(value -> value instanceof Number).map(Number.class::cast).map(Number::longValue).orElse(null);
        }

        private static String castAssociationType(Map.Entry<String, Object> entry) {
            return Optional.ofNullable(entry.getValue()).map(String::valueOf).orElse(null);
        }

        private static boolean isIdEntry(Map.Entry<String, Object> entry) {
            String key = entry.getKey();
            return key.endsWith("Id") || key.endsWith("_id");
        }

        private static boolean isTypeEntry(Map.Entry<String, Object> entry) {
            String key = entry.getKey();
            return key.endsWith("Type") || key.endsWith("_type");
        }
    }
}

