/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.Payload;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EntityChange {
    private static final int BEFORE_VALUE_INDEX = 0;
    private static final int AFTER_VALUE_INDEX = 1;
    private List<Payload> changes;

    @JsonCreator
    public EntityChange(List<Payload> changes) {
        if (changes.size() != 2) {
            throw new IllegalArgumentException("Changes must have two elements");
        }
        this.changes = changes;
    }

    public <T> T beforeValue(Class<T> clazz) {
        return this.selectValue(0).get(clazz);
    }

    public <T> T afterValue(Class<T> clazz) {
        return this.selectValue(1).get(clazz);
    }

    private Payload selectValue(int index) {
        return Optional.ofNullable(this.changes.get(index)).orElse(Payload.nullValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityChange that = (EntityChange)o;
        return Objects.equals(this.changes, that.changes);
    }

    public int hashCode() {
        return Objects.hash(this.changes);
    }

    public String toString() {
        return this.changes.toString();
    }

    @JsonValue
    public List<Payload> getChanges() {
        return this.changes;
    }
}

