/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TimestampConverter {
    private static final List<DateTimeFormatter> DATE_FORMATS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss 'UTC'"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss X"), DateTimeFormatter.ISO_DATE_TIME);

    private TimestampConverter() {
    }

    public static Optional<LocalDateTime> convertToLocalDateTime(String dateAsString) {
        return DATE_FORMATS.stream().map(formatter -> TimestampConverter.parseDate(formatter, dateAsString)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<LocalDateTime> parseDate(DateTimeFormatter formatter, String dateAsString) {
        try {
            return Optional.of(LocalDateTime.parse(dateAsString, formatter));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

