/*
 * Decompiled with CFR 0.152.
 */
package be.joengenduvel.java.verifiers;

import be.joengenduvel.java.verifiers.ConfigurationManager;
import be.joengenduvel.java.verifiers.WrongToStringImplementationException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ToStringVerifier<T> {
    private static final List<String> FIELDS_TO_ALWAYS_IGNORE = ConfigurationManager.getInstance().getFieldsToIgnore();
    private final Class<T> classToVerify;
    private final List<String> fieldsToIgnore;

    private ToStringVerifier(Class<T> classToVerify) {
        this.classToVerify = classToVerify;
        this.fieldsToIgnore = new ArrayList<String>();
    }

    public static <R> ToStringVerifier<R> forClass(Class<R> classToVerify) {
        return new ToStringVerifier<R>(classToVerify);
    }

    public ToStringVerifier<T> ignore(String ... fieldNames) {
        this.fieldsToIgnore.addAll(Arrays.asList(fieldNames));
        return this;
    }

    public void containsAllPrivateFields(T objectToTest) {
        String toString = this.getToString(objectToTest);
        for (Field privateDeclaredField : this.getDeclaredPrivateFields(this.classToVerify)) {
            if (!toString.contains(privateDeclaredField.getName())) {
                throw WrongToStringImplementationException.forFieldNameNotFound(privateDeclaredField, this.classToVerify, toString);
            }
            try {
                String fieldValueString = String.valueOf(privateDeclaredField.get(objectToTest));
                if (toString.contains(fieldValueString)) continue;
                throw WrongToStringImplementationException.forValueNotFound(privateDeclaredField, fieldValueString, this.classToVerify, toString);
            }
            catch (IllegalAccessException e) {
                throw WrongToStringImplementationException.forIllegalAccess(privateDeclaredField, this.classToVerify, e);
            }
        }
    }

    private String getToString(T objectToTest) {
        this.verifyNotNull(objectToTest);
        return objectToTest.toString();
    }

    private void verifyNotNull(T objectToTest) {
        if (objectToTest == null) {
            throw WrongToStringImplementationException.forObjectNull(this.classToVerify);
        }
    }

    public void containsClassName(T objectToTest) {
        String toString = this.getToString(objectToTest);
        if (!toString.contains(this.classToVerify.getSimpleName())) {
            throw WrongToStringImplementationException.forClassNameNotFound(toString, this.classToVerify.getSimpleName(), this.classToVerify);
        }
    }

    private List<Field> getDeclaredPrivateFields(Class<?> aClass) {
        Field[] declaredFields;
        ArrayList<Field> privateDeclaredFields = new ArrayList<Field>();
        for (Field declaredField : declaredFields = aClass.getDeclaredFields()) {
            if (!Modifier.isPrivate(declaredField.getModifiers()) || this.fieldNeedsToBeIgnored(declaredField.getName())) continue;
            declaredField.setAccessible(true);
            privateDeclaredFields.add(declaredField);
        }
        return privateDeclaredFields;
    }

    private boolean fieldNeedsToBeIgnored(String name) {
        return FIELDS_TO_ALWAYS_IGNORE.contains(name) || this.fieldsToIgnore.contains(name);
    }
}

