/*
 * Decompiled with CFR 0.152.
 */
package be.jacobsvanroy.springsqlunit.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.CannotReadScriptException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ScriptUtils {
    private static final Log logger = LogFactory.getLog(ScriptUtils.class);
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String EOF_STATEMENT_SEPARATOR = "^^^ END OF SCRIPT ^^^";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";

    private ScriptUtils() {
    }

    public static void splitSqlScript(EncodedResource resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) {
        Assert.hasText((String)script, (String)"script must not be null or empty");
        Assert.notNull((Object)separator, (String)"separator must not be null");
        Assert.hasText((String)commentPrefix, (String)"commentPrefix must not be null or empty");
        Assert.hasText((String)blockCommentStartDelimiter, (String)"blockCommentStartDelimiter must not be null or empty");
        Assert.hasText((String)blockCommentEndDelimiter, (String)"blockCommentEndDelimiter must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        boolean inEscape = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            int c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (c == 39) {
                boolean bl = inLiteral = !inLiteral;
            }
            if (!inLiteral) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf(FALLBACK_STATEMENT_SEPARATOR, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new RuntimeException(String.format("Missing block comment end delimiter [%s] for resource [%s].", blockCommentEndDelimiter, resource.toString()));
                }
                if (c == 32 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readScript(EncodedResource resource, String commentPrefix, String separator) throws IOException {
        LineNumberReader lnr = new LineNumberReader(resource.getReader());
        try {
            String string = ScriptUtils.readScript(lnr, commentPrefix, separator);
            return string;
        }
        finally {
            lnr.close();
        }
    }

    public static String readScript(LineNumberReader lineNumberReader, String commentPrefix, String separator) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (commentPrefix != null && !currentStatement.startsWith(commentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        ScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void executeSqlScript(DataSource dataSource, Resource resource) {
        ScriptUtils.executeSqlScript(dataSource, new EncodedResource(resource));
    }

    public static void executeSqlScript(DataSource dataSource, EncodedResource resource) {
        ScriptUtils.executeSqlScript(dataSource, resource, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static void executeSqlScript(DataSource dataSource, EncodedResource resource, String commentPrefix, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) {
        try {
            String script;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Executing SQL script from " + resource));
            }
            long startTime = System.currentTimeMillis();
            LinkedList<String> statements = new LinkedList<String>();
            try {
                script = ScriptUtils.readScript(resource, commentPrefix, separator);
            }
            catch (IOException ex) {
                throw new CannotReadScriptException(resource, (Throwable)ex);
            }
            if (separator == null) {
                separator = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!EOF_STATEMENT_SEPARATOR.equals(separator) && !ScriptUtils.containsSqlScriptDelimiters(script, separator)) {
                separator = FALLBACK_STATEMENT_SEPARATOR;
            }
            ScriptUtils.splitSqlScript(resource, script, separator, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            for (String statement : statements) {
                JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
                jdbcTemplate.execute(statement);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Executed SQL script from " + resource + " in " + elapsedTime + " ms."));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to execute database script from resource [" + resource + "]", ex);
        }
    }
}

