/*
 * Decompiled with CFR 0.152.
 */
package be.jacobsvanroy.springsqlunit.sql;

import be.jacobsvanroy.springsqlunit.comparator.FileComparator;
import be.jacobsvanroy.springsqlunit.sql.SqlExecutor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SqlRunner {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final SqlExecutor sqlExecutor;

    public static SqlRunner of(SqlExecutor sqlExecutor) {
        return new SqlRunner(sqlExecutor);
    }

    private SqlRunner(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public void runSqlFiles(String[] files, DataSource dataSource) {
        for (String file : files) {
            this.runSqlFile(file, dataSource);
        }
    }

    private void runSqlFile(String sqlFile, DataSource dataSource) {
        ClassPathResource resource = new ClassPathResource(sqlFile);
        File scriptFile = this.getFile(resource);
        this.runSqlFile(scriptFile, dataSource);
    }

    private void runSqlFile(File scriptFile, DataSource dataSource) {
        if (scriptFile.exists()) {
            if (scriptFile.isDirectory()) {
                this.executeDirectory(dataSource, scriptFile);
            } else {
                this.executeSqlScript(dataSource, scriptFile);
            }
        } else {
            throw new RuntimeException("File " + scriptFile.getPath() + " does not exist");
        }
    }

    private File getFile(ClassPathResource resource) {
        File scriptFile;
        try {
            scriptFile = resource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return scriptFile;
    }

    private List<File> getSortedFiles(File[] files) {
        if (files == null) {
            return new ArrayList<File>();
        }
        List<File> result = Arrays.asList(files);
        Collections.sort(result, new FileComparator());
        return result;
    }

    private void executeSqlScript(DataSource dataSource, File file) {
        this.logger.debug((Object)("Running sql file: " + file.getName()));
        this.sqlExecutor.executeSqlScript(dataSource, (Resource)new FileSystemResource(file));
    }

    private void executeDirectory(DataSource dataSource, File directory) {
        List<File> files = this.getSortedFiles(directory.listFiles());
        for (File file : files) {
            this.runSqlFile(file, dataSource);
        }
    }
}

