/*
 * Decompiled with CFR 0.152.
 */
package be.jacobsvanroy.springsqlunit;

import be.jacobsvanroy.springsqlunit.annotation.SqlSetUp;
import be.jacobsvanroy.springsqlunit.sql.SqlExecutor;
import be.jacobsvanroy.springsqlunit.sql.SqlRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class SpringSqlUnitTestExecutionListener
extends AbstractTestExecutionListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private SqlRunner sqlRunner = SqlRunner.of(new SqlExecutor());

    public void beforeTestClass(TestContext testContext) throws Exception {
        super.beforeTestClass(testContext);
        this.logger.trace((Object)"Running before test class");
        this.runSqlBefore(testContext.getTestClass().getDeclaredAnnotations(), testContext.getApplicationContext());
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        super.afterTestClass(testContext);
        this.logger.trace((Object)"Running after test class");
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        super.beforeTestMethod(testContext);
        this.logger.trace((Object)"Running before test method");
        this.runSqlBefore(testContext.getTestMethod().getDeclaredAnnotations(), testContext.getApplicationContext());
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        super.afterTestMethod(testContext);
        this.logger.trace((Object)"Running after test method");
    }

    private void runSqlBefore(Annotation[] declaredAnnotations, ApplicationContext appContext) {
        List<Annotation> annotations = this.getAnnotation(declaredAnnotations, SqlSetUp.class);
        for (Annotation annotation : annotations) {
            SqlSetUp sqlBeforeAnnotation = (SqlSetUp)annotation;
            this.sqlRunner.runSqlFiles(sqlBeforeAnnotation.files(), this.getDataSource(appContext, sqlBeforeAnnotation.dataSource()));
        }
    }

    private List<Annotation> getAnnotation(Annotation[] declaredAnnotations, Class<? extends Annotation> annotationType) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation declaredAnnotation : declaredAnnotations) {
            if (!declaredAnnotation.annotationType().equals(annotationType)) continue;
            result.add(declaredAnnotation);
        }
        return result;
    }

    private DataSource getDataSource(ApplicationContext appContext, String dataSource) {
        return (DataSource)appContext.getBean(dataSource);
    }
}

