/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser;

import be.intersentia.elasticsearch.configuration.annotation.mapping.IndexOptions;
import be.intersentia.elasticsearch.configuration.annotation.mapping.OptionalBoolean;
import be.intersentia.elasticsearch.configuration.annotation.mapping.TextMapping;
import be.intersentia.elasticsearch.configuration.parser.AbstractMappingParser;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TextMappingParser
extends AbstractMappingParser<TextMapping> {
    public TextMappingParser(Class<?> clazz, Field field, TextMapping annotation) {
        super(clazz, field, annotation);
    }

    @Override
    public String getFieldName() {
        return this.getFieldName(((TextMapping)this.annotation).field());
    }

    @Override
    public String getMappingName() {
        return ((TextMapping)this.annotation).mappingName();
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public void addMapping(Map<String, Object> mapping) {
        if (!"DEFAULT".equals(((TextMapping)this.annotation).analyzer())) {
            mapping.put("analyzer", ((TextMapping)this.annotation).analyzer());
        }
        mapping.put("boost", Float.valueOf(((TextMapping)this.annotation).boost()));
        if (ArrayUtils.isNotEmpty((Object[])((TextMapping)this.annotation).copyTo())) {
            mapping.put("copy_to", ((TextMapping)this.annotation).copyTo());
        }
        mapping.put("eager_global_ordinals", ((TextMapping)this.annotation).eagerGlobalOrdinals());
        mapping.put("fielddata", ((TextMapping)this.annotation).fieldData());
        this.addFieldDataFrequencyFilterMapping(mapping, (TextMapping)this.annotation);
        if (((TextMapping)this.annotation).includeInAll() != OptionalBoolean.DEFAULT) {
            mapping.put("include_in_all", ((TextMapping)this.annotation).includeInAll().name().toLowerCase());
        }
        mapping.put("index", ((TextMapping)this.annotation).index());
        if (((TextMapping)this.annotation).indexOptions() != IndexOptions.DEFAULT) {
            mapping.put("index_options", (Object)((TextMapping)this.annotation).indexOptions());
        }
        mapping.put("norms", ((TextMapping)this.annotation).norms());
        if (((TextMapping)this.annotation).positionIncrementGap() != 100) {
            mapping.put("position_increment_gap", ((TextMapping)this.annotation).positionIncrementGap());
        }
        mapping.put("store", ((TextMapping)this.annotation).store());
        if (!"DEFAULT".equals(((TextMapping)this.annotation).searchAnalyzer())) {
            mapping.put("search_analyzer", ((TextMapping)this.annotation).searchAnalyzer());
        }
        if (!"DEFAULT".equals(((TextMapping)this.annotation).searchQuoteAnalyzer())) {
            mapping.put("search_quote_analyzer", ((TextMapping)this.annotation).searchQuoteAnalyzer());
        }
        if (!"DEFAULT".equals(((TextMapping)this.annotation).similarity())) {
            mapping.put("similarity", ((TextMapping)this.annotation).similarity());
        }
        mapping.put("term_vector", ((TextMapping)this.annotation).termVector().name().toLowerCase());
    }

    private void addFieldDataFrequencyFilterMapping(Map<String, Object> mapping, TextMapping annotation) {
        TextMapping.FieldDataFrequencyFilter frequencyFilter = annotation.fieldDataFrequencyFilter();
        if (frequencyFilter.min() != 0.0f || frequencyFilter.max() != 0.0f || frequencyFilter.minSegmentSize() != 0) {
            HashMap<String, Number> frequencyMap = new HashMap<String, Number>();
            frequencyMap.put("min", Float.valueOf(frequencyFilter.min()));
            frequencyMap.put("max", Float.valueOf(frequencyFilter.max()));
            frequencyMap.put("min_segment_size", frequencyFilter.minSegmentSize());
            mapping.put("fielddata_frequency_filter", frequencyMap);
        }
    }
}

