/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser;

import be.intersentia.elasticsearch.configuration.annotation.mapping.ObjectMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.OptionalBoolean;
import be.intersentia.elasticsearch.configuration.factory.MappingFactory;
import be.intersentia.elasticsearch.configuration.parser.AbstractMappingParser;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ObjectMappingParser
extends AbstractMappingParser<ObjectMapping> {
    public ObjectMappingParser(Class<?> clazz, Field field, ObjectMapping annotation) {
        super(clazz, field, annotation);
    }

    @Override
    public String getFieldName() {
        return this.getFieldName(((ObjectMapping)this.annotation).field());
    }

    @Override
    public String getMappingName() {
        return "DEFAULT";
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public void addMapping(Map<String, Object> mapping) {
        mapping.put("dynamic", ((ObjectMapping)this.annotation).dynamic().name().toLowerCase());
        mapping.put("enabled", ((ObjectMapping)this.annotation).enabled());
        mapping.put("type", "object");
        if (((ObjectMapping)this.annotation).includeInAll() != OptionalBoolean.DEFAULT) {
            mapping.put("include_in_all", ((ObjectMapping)this.annotation).includeInAll().name().toLowerCase());
        }
        if (this.field == null) {
            mapping.put("properties", new HashMap());
        } else if (Collection.class.isAssignableFrom(this.field.getType())) {
            ParameterizedType listType = (ParameterizedType)this.field.getGenericType();
            Class listClass = (Class)listType.getActualTypeArguments()[0];
            mapping.putAll(MappingFactory.createMapping(Collections.singletonList(listClass), false, this.clazz));
        } else {
            mapping.putAll(MappingFactory.createMapping(Collections.singletonList(this.field.getType()), false, this.clazz));
        }
    }
}

