/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.factory;

import be.intersentia.elasticsearch.configuration.annotation.analyzer.Analyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CharFilter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomAnalyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomNormalizer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Filter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Property;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Tokenizer;
import be.intersentia.elasticsearch.configuration.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisFactory {
    private static final Logger log = LogManager.getLogger(AnalysisFactory.class);

    public static Map<String, ?> createAnalysis(List<Class<?>> classes) {
        String label = StringUtils.join(classes, Class::getSimpleName, ", ");
        log.info("Creating ElasticSearch analysis for " + label);
        Analysis analysis = new Analysis();
        for (Class<?> clazz : classes) {
            log.trace(clazz.getSimpleName() + ": Inspecting annotations");
            AnalysisFactory.addToAnalysis(analysis, clazz);
        }
        Map map = analysis.toMap();
        if (log.isDebugEnabled()) {
            log.debug("Returning analysis for " + StringUtils.prettyPrint(label, map));
        }
        return Collections.singletonMap("analysis", map);
    }

    private static void addToAnalysis(Analysis analysis, Class<?> clazz) {
        HashMap<String, Object> elementMap;
        for (CharFilter charFilter : (CharFilter[])clazz.getAnnotationsByType(CharFilter.class)) {
            analysis.charFilters.put(charFilter.name(), AnalysisFactory.createConfiguration(charFilter.type(), charFilter.properties()));
        }
        for (Annotation annotation : (Tokenizer[])clazz.getAnnotationsByType(Tokenizer.class)) {
            analysis.tokenizers.put(annotation.name(), AnalysisFactory.createConfiguration(annotation.type(), annotation.properties()));
        }
        for (Annotation annotation : (Filter[])clazz.getAnnotationsByType(Filter.class)) {
            analysis.filters.put(annotation.name(), AnalysisFactory.createConfiguration(annotation.type(), annotation.properties()));
        }
        for (Annotation annotation : (Analyzer[])clazz.getAnnotationsByType(Analyzer.class)) {
            analysis.analyzers.put(annotation.name(), AnalysisFactory.createConfiguration(annotation.type(), annotation.properties()));
        }
        for (Annotation annotation : (CustomAnalyzer[])clazz.getAnnotationsByType(CustomAnalyzer.class)) {
            elementMap = new HashMap<String, Object>();
            elementMap.put("char_filter", annotation.charFilters());
            elementMap.put("tokenizer", annotation.tokenizer());
            elementMap.put("filter", annotation.filters());
            elementMap.put("position_increment_gap", annotation.positionIncrementGap());
            analysis.analyzers.put(annotation.name(), elementMap);
        }
        for (Annotation annotation : (CustomNormalizer[])clazz.getAnnotationsByType(CustomNormalizer.class)) {
            elementMap = new HashMap();
            elementMap.put("char_filter", annotation.charFilters());
            elementMap.put("filter", annotation.filters());
            analysis.normalizers.put(annotation.name(), elementMap);
        }
    }

    private static Map<String, Object> createConfiguration(String type, Property[] properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        for (Property property : properties) {
            map.put(property.key(), property.value());
        }
        return map;
    }

    private static class Analysis {
        private final Map<String, Object> charFilters = new HashMap<String, Object>();
        private final Map<String, Object> tokenizers = new HashMap<String, Object>();
        private final Map<String, Object> filters = new HashMap<String, Object>();
        private final Map<String, Object> analyzers = new HashMap<String, Object>();
        private final Map<String, Object> normalizers = new HashMap<String, Object>();

        private Analysis() {
        }

        private Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!this.charFilters.isEmpty()) {
                map.put("char_filter", this.charFilters);
            }
            if (!this.tokenizers.isEmpty()) {
                map.put("tokenizer", this.tokenizers);
            }
            if (!this.filters.isEmpty()) {
                map.put("filter", this.filters);
            }
            if (!this.analyzers.isEmpty()) {
                map.put("analyzer", this.analyzers);
            }
            if (!this.normalizers.isEmpty()) {
                map.put("normalizer", this.normalizers);
            }
            return map;
        }
    }
}

