/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser;

import be.intersentia.elasticsearch.configuration.annotation.mapping.NumericMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.OptionalBoolean;
import be.intersentia.elasticsearch.configuration.parser.AbstractMappingParser;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumericMappingParser
extends AbstractMappingParser<NumericMapping> {
    public NumericMappingParser(Class<?> clazz, Field field, NumericMapping annotation) {
        super(clazz, field, annotation);
    }

    @Override
    public String getFieldName() {
        return this.getFieldName(((NumericMapping)this.annotation).field());
    }

    @Override
    public String getMappingName() {
        return "DEFAULT";
    }

    @Override
    public String getType() {
        if (((NumericMapping)this.annotation).type() != NumericMapping.NumericType.DEFAULT) {
            return ((NumericMapping)this.annotation).type().getValue();
        }
        String typeName = this.field.getType().getSimpleName().toLowerCase();
        if (typeName.contains("long")) {
            return NumericMapping.NumericType.LONG.getValue();
        }
        if (typeName.contains("int")) {
            return NumericMapping.NumericType.INTEGER.getValue();
        }
        if (typeName.contains("short")) {
            return NumericMapping.NumericType.SHORT.getValue();
        }
        if (typeName.contains("byte")) {
            return NumericMapping.NumericType.BYTE.getValue();
        }
        if (typeName.contains("double")) {
            return NumericMapping.NumericType.DOUBLE.getValue();
        }
        if (typeName.contains("float")) {
            return NumericMapping.NumericType.FLOAT.getValue();
        }
        return NumericMapping.NumericType.DOUBLE.getValue();
    }

    @Override
    public void addMapping(Map<String, Object> mapping) {
        mapping.put("boost", Float.valueOf(((NumericMapping)this.annotation).boost()));
        mapping.put("coerce", ((NumericMapping)this.annotation).coerce());
        if (ArrayUtils.isNotEmpty((Object[])((NumericMapping)this.annotation).copyTo())) {
            mapping.put("copy_to", ((NumericMapping)this.annotation).copyTo());
        }
        mapping.put("doc_values", ((NumericMapping)this.annotation).docValues());
        mapping.put("ignore_malformed", ((NumericMapping)this.annotation).ignoreMalformed());
        if (((NumericMapping)this.annotation).includeInAll() != OptionalBoolean.DEFAULT) {
            mapping.put("include_in_all", ((NumericMapping)this.annotation).includeInAll().name().toLowerCase());
        }
        mapping.put("index", ((NumericMapping)this.annotation).index());
        if (!"DEFAULT".equals(((NumericMapping)this.annotation).nullValue())) {
            mapping.put("null_value", NumericMappingParser.getNullValue(((NumericMapping)this.annotation).nullValue()));
        }
        mapping.put("store", ((NumericMapping)this.annotation).store());
    }

    private static Number getNullValue(String value) {
        try {
            return NumberUtils.toDouble((String)value);
        }
        catch (Exception e) {
            throw new IllegalStateException("nullValue needs to be castable to a Number");
        }
    }
}

