/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMappingParser<T extends Annotation> {
    protected Class<?> clazz;
    protected Field field;
    protected T annotation;

    AbstractMappingParser(Class<?> clazz, Field field, T annotation) {
        this.clazz = clazz;
        this.field = field;
        this.annotation = annotation;
    }

    public abstract String getFieldName();

    String getFieldName(String fieldName) {
        if (!"DEFAULT".equals(fieldName)) {
            return fieldName;
        }
        if (this.field == null) {
            throw new IllegalArgumentException("Class " + this.clazz.getName() + " is annotated with an ElasticSearch " + this.getType() + " mapping without a fieldName. FieldName is only optional for method annotations");
        }
        return this.field.getName();
    }

    public abstract String getMappingName();

    public abstract String getType();

    public Map<String, Object> getMapping() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.getType());
        this.addMapping(map);
        return map;
    }

    protected abstract void addMapping(Map<String, Object> var1);

    public boolean hasDefault() {
        return "DEFAULT".equals(this.getMappingName());
    }
}

