/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.factory;

import be.intersentia.elasticsearch.configuration.annotation.templates.DynamicTemplate;
import be.intersentia.elasticsearch.configuration.parser.AbstractMappingParser;
import be.intersentia.elasticsearch.configuration.parser.MappingParserConfiguration;
import be.intersentia.elasticsearch.configuration.parser.MultipleMappingParserConfiguration;
import be.intersentia.elasticsearch.configuration.parser.MultipleTemplateParserConfiguration;
import be.intersentia.elasticsearch.configuration.parser.TemplateParserConfiguration;
import be.intersentia.elasticsearch.configuration.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappingFactory {
    private static final Logger log = LogManager.getLogger(MappingFactory.class);
    private static Map<String, AtomicInteger> recursiveCounts = new HashMap<String, AtomicInteger>();

    public static Map<String, ?> createMapping(List<Class<?>> classes, boolean disableDynamicProperties) {
        return MappingFactory.createMapping(classes, disableDynamicProperties, null, null);
    }

    public static Map<String, ?> createMapping(List<Class<?>> classes, boolean disableDynamicProperties, String parent) {
        return MappingFactory.createMapping(classes, disableDynamicProperties, parent, null);
    }

    public static Map<String, ?> createMapping(List<Class<?>> classes, boolean disableDynamicProperties, Class<?> parentClass) {
        return MappingFactory.createMapping(classes, disableDynamicProperties, null, parentClass);
    }

    public static Map<String, ?> createMapping(List<Class<?>> classes, boolean disableDynamicProperties, String parent, Class<?> parentClass) {
        String label = StringUtils.join(classes, Class::getSimpleName, ", ");
        log.info("Creating ElasticSearch mapping for " + label);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (disableDynamicProperties) {
            map.put("dynamic", "strict");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parent)) {
            map.put("_parent", Collections.singletonMap("type", parent));
        }
        ArrayList<Map<String, Object>> templatesList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (Class<?> clazz : classes) {
            log.trace(clazz.getSimpleName() + ": Inspecting annotations");
            Annotation[] annotations = clazz.getDeclaredAnnotations();
            MappingFactory.addTemplates(templatesList, clazz, annotations);
            MappingFactory.addMapping(propertiesMap, clazz, null, annotations);
            for (Field field : MappingFactory.getFields(clazz)) {
                log.trace(clazz.getSimpleName() + '.' + field.getName() + ": Inspecting annotations");
                annotations = field.getDeclaredAnnotations();
                String fullName = (parentClass == null ? "root" : parentClass.getSimpleName()) + "." + clazz.getSimpleName() + '.' + field.getName();
                if (MappingFactory.isRecursive(field, clazz)) {
                    AtomicInteger count = recursiveCounts.getOrDefault(fullName, new AtomicInteger(0));
                    count.incrementAndGet();
                    recursiveCounts.put(fullName, count);
                    if (count.intValue() < 5) {
                        MappingFactory.addMapping(propertiesMap, clazz, field, annotations);
                        continue;
                    }
                    log.warn("ignoring " + fullName);
                    recursiveCounts.put(fullName, new AtomicInteger(0));
                    continue;
                }
                MappingFactory.addMapping(propertiesMap, clazz, field, annotations);
            }
        }
        if (!templatesList.isEmpty()) {
            map.put("dynamic_templates", templatesList);
        }
        if (!propertiesMap.isEmpty()) {
            map.put("properties", propertiesMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning mapping for " + StringUtils.prettyPrint(label, map));
        }
        return map;
    }

    private static boolean isRecursive(Field field, Class<?> clazz) {
        boolean result;
        block4: {
            result = false;
            try {
                Type type = field.getGenericType();
                if (type.getClass().equals(clazz)) {
                    result = true;
                }
                if (!(type instanceof ParameterizedType)) break block4;
                ParameterizedType pt = (ParameterizedType)type;
                for (Type t : pt.getActualTypeArguments()) {
                    if (!t.equals(clazz)) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    private static void addTemplates(List<Map<String, Object>> templatesList, Class<?> clazz, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            log.trace(clazz.getSimpleName() + ": Inspecting @" + annotation.annotationType().getSimpleName());
            try {
                MultipleTemplateParserConfiguration multipleParserConfiguration = annotation.annotationType().getAnnotation(MultipleTemplateParserConfiguration.class);
                if (multipleParserConfiguration != null) {
                    for (Annotation subAnnotation : (Annotation[])MappingFactory.getValue(annotation, "value")) {
                        MappingFactory.addTemplate(templatesList, clazz, subAnnotation);
                    }
                    continue;
                }
                MappingFactory.addTemplate(templatesList, clazz, annotation);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create MappingParser for template " + clazz.getSimpleName(), e);
            }
        }
    }

    private static void addTemplate(List<Map<String, Object>> templatesList, Class<?> clazz, Annotation annotation) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        TemplateParserConfiguration mappingConfiguration = annotation.annotationType().getAnnotation(TemplateParserConfiguration.class);
        if (mappingConfiguration != null) {
            DynamicTemplate template = (DynamicTemplate)MappingFactory.getValue(annotation, "template");
            Annotation mapping = (Annotation)MappingFactory.getValue(annotation, "mapping");
            AbstractMappingParser parser = mappingConfiguration.parser().getConstructor(Class.class, Field.class, mapping.annotationType()).newInstance(clazz, null, mapping);
            HashMap<String, Object> templateMap = new HashMap<String, Object>();
            if (!"DEFAULT".equals(template.matchMappingType())) {
                templateMap.put("match_mapping_type", template.matchMappingType());
            }
            if (!"DEFAULT".equals(template.match())) {
                templateMap.put("match", template.match());
            }
            if (!"DEFAULT".equals(template.unMatch())) {
                templateMap.put("unmatch", template.unMatch());
            }
            if (!"DEFAULT".equals(template.pathMatch())) {
                templateMap.put("path_match", template.pathMatch());
            }
            if (!"DEFAULT".equals(template.pathUnMatch())) {
                templateMap.put("path_unmatch", template.pathUnMatch());
            }
            templateMap.put("mapping", parser.getMapping());
            templatesList.add(Collections.singletonMap(template.name(), templateMap));
        }
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static void addMapping(Map<String, Object> map, Class<?> clazz, Field field, Annotation[] annotations) {
        AbstractMappingParser<?> baseParser = null;
        ArrayList nestedParsers = new ArrayList();
        for (Annotation annotation : annotations) {
            log.trace(MappingFactory.getName(clazz, field) + ": Inspecting @" + annotation.annotationType().getSimpleName());
            try {
                List<AbstractMappingParser<?>> annotationParsers = MappingFactory.getParsers(clazz, field, annotation);
                for (AbstractMappingParser<?> parser : annotationParsers) {
                    if (field == null) {
                        map.put(parser.getFieldName(), parser.getMapping());
                        continue;
                    }
                    if (parser.hasDefault()) {
                        if (baseParser != null) {
                            throw new IllegalStateException("More than one DEFAULT Mapping found for field " + MappingFactory.getName(clazz, field));
                        }
                        baseParser = parser;
                        continue;
                    }
                    nestedParsers.add(parser);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create MappingParser for mapped field " + MappingFactory.getName(clazz, field), e);
            }
        }
        if (baseParser == null && !nestedParsers.isEmpty()) {
            throw new IllegalStateException("At least one DEFAULT Mapping is required for field " + MappingFactory.getName(clazz, field));
        }
        if (baseParser != null) {
            Map<String, Object> baseMap = baseParser.getMapping();
            HashMap<String, Map<String, Object>> nestedMap = new HashMap<String, Map<String, Object>>();
            for (AbstractMappingParser abstractMappingParser : nestedParsers) {
                nestedMap.put(abstractMappingParser.getMappingName(), abstractMappingParser.getMapping());
            }
            baseMap.put("fields", nestedMap);
            map.put(baseParser.getFieldName(), baseMap);
        }
    }

    private static List<AbstractMappingParser<?>> getParsers(Class<?> clazz, Field field, Annotation annotation) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        MultipleMappingParserConfiguration multipleParserConfiguration;
        ArrayList parsers = new ArrayList();
        MappingParserConfiguration mappingConfiguration = annotation.annotationType().getAnnotation(MappingParserConfiguration.class);
        if (mappingConfiguration != null) {
            log.trace(MappingFactory.getName(clazz, field) + ": Parsing with " + mappingConfiguration.parser().getSimpleName());
            parsers.add(mappingConfiguration.parser().getConstructor(Class.class, Field.class, annotation.annotationType()).newInstance(clazz, field, annotation));
        }
        if ((multipleParserConfiguration = annotation.annotationType().getAnnotation(MultipleMappingParserConfiguration.class)) != null) {
            log.trace(MappingFactory.getName(clazz, field) + ": Parsing multiple with " + multipleParserConfiguration.parser().getSimpleName());
            try {
                Object[] values;
                for (Object value : values = (Object[])annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0])) {
                    Annotation subAnnotation = (Annotation)value;
                    parsers.add(multipleParserConfiguration.parser().getConstructor(Class.class, Field.class, subAnnotation.annotationType()).newInstance(clazz, field, subAnnotation));
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Annotation " + annotation.annotationType() + " should have a value() method");
            }
        }
        return parsers;
    }

    private static <T> T getValue(Annotation annotation, String member) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (T)annotation.annotationType().getDeclaredMethod(member, new Class[0]).invoke((Object)annotation, new Object[0]);
    }

    private static String getName(Class<?> clazz, Field field) {
        return field == null ? clazz.getSimpleName() : clazz.getSimpleName() + '.' + field.getName();
    }
}

