/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser.mapping;

import be.intersentia.elasticsearch.configuration.annotation.mapping.ObjectMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.ObjectMappings;
import be.intersentia.elasticsearch.configuration.factory.MappingFactory;
import be.intersentia.elasticsearch.configuration.parser.mapping.AbstractMappingParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectMappingParser
extends AbstractMappingParser<ObjectMapping> {
    public ObjectMappingParser(Class<?> clazz, Field field, ObjectMapping annotation) {
        super(clazz, field, (Annotation[])new ObjectMapping[]{annotation});
    }

    public ObjectMappingParser(Class<?> clazz, Field field, ObjectMappings annotations) {
        super(clazz, field, (Annotation[])annotations.value());
    }

    @Override
    public String getFieldName(ObjectMapping annotation) {
        return this.getFieldName(annotation, annotation.field());
    }

    @Override
    public String getMappingName(ObjectMapping annotation) {
        return "DEFAULT";
    }

    @Override
    public String getType(ObjectMapping annotation) {
        return "object";
    }

    @Override
    public void addMapping(Map<String, Object> map, List<AbstractMappingParser<?>> nestedParsers, boolean isNested) {
        for (ObjectMapping annotation : this.annotations) {
            HashMap<String, Object> annotationMap = new HashMap<String, Object>();
            this.addMapping((Map<String, Object>)annotationMap, annotation);
            map.put(this.getFieldName(annotation), annotationMap);
        }
    }

    @Override
    public void addMapping(Map<String, Object> mapping, ObjectMapping annotation) {
        mapping.put("dynamic", annotation.dynamic().name().toLowerCase());
        mapping.put("enabled", annotation.enabled());
        mapping.put("type", "object");
        if (this.field == null) {
            mapping.put("properties", new HashMap());
        } else if (Collection.class.isAssignableFrom(this.field.getType())) {
            ParameterizedType listType = (ParameterizedType)this.field.getGenericType();
            Class listClass = (Class)listType.getActualTypeArguments()[0];
            mapping.putAll(MappingFactory.createMapping(listClass, false, this.clazz));
        } else {
            mapping.putAll(MappingFactory.createMapping(this.field.getType(), false, this.clazz));
        }
    }
}

