/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser.mapping;

import be.intersentia.elasticsearch.configuration.annotation.mapping.NumericMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.NumericMappings;
import be.intersentia.elasticsearch.configuration.parser.mapping.AbstractMappingParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumericMappingParser
extends AbstractMappingParser<NumericMapping> {
    public NumericMappingParser(Class<?> clazz, Field field, NumericMapping annotation) {
        super(clazz, field, (Annotation[])new NumericMapping[]{annotation});
    }

    public NumericMappingParser(Class<?> clazz, Field field, NumericMappings annotations) {
        super(clazz, field, (Annotation[])annotations.value());
    }

    @Override
    public String getFieldName(NumericMapping annotation) {
        return this.getFieldName(annotation, annotation.field());
    }

    @Override
    public String getMappingName(NumericMapping annotation) {
        return "DEFAULT";
    }

    @Override
    public String getType(NumericMapping annotation) {
        return this.getNumericType(annotation).name().toLowerCase();
    }

    private NumericMapping.NumericType getNumericType(NumericMapping annotation) {
        if (annotation.type() != NumericMapping.NumericType.DEFAULT) {
            return annotation.type();
        }
        String typeName = this.field.getType().getSimpleName().toLowerCase();
        if (typeName.contains("long")) {
            return NumericMapping.NumericType.LONG;
        }
        if (typeName.contains("int")) {
            return NumericMapping.NumericType.INTEGER;
        }
        if (typeName.contains("short")) {
            return NumericMapping.NumericType.SHORT;
        }
        if (typeName.contains("byte")) {
            return NumericMapping.NumericType.BYTE;
        }
        if (typeName.contains("double")) {
            return NumericMapping.NumericType.DOUBLE;
        }
        if (typeName.contains("float")) {
            return NumericMapping.NumericType.FLOAT;
        }
        return NumericMapping.NumericType.DOUBLE;
    }

    @Override
    public void addMapping(Map<String, Object> mapping, NumericMapping annotation) {
        mapping.put("boost", Float.valueOf(annotation.boost()));
        mapping.put("coerce", annotation.coerce());
        if (ArrayUtils.isNotEmpty((Object[])annotation.copyTo())) {
            mapping.put("copy_to", annotation.copyTo());
        }
        mapping.put("doc_values", annotation.docValues());
        mapping.put("ignore_malformed", annotation.ignoreMalformed());
        mapping.put("index", annotation.index());
        if (!"DEFAULT".equals(annotation.nullValue())) {
            mapping.put("null_value", NumericMappingParser.getNullValue(annotation.nullValue()));
        }
        mapping.put("store", annotation.store());
    }

    private static Number getNullValue(String value) {
        try {
            return NumberUtils.toDouble((String)value);
        }
        catch (Exception e) {
            throw new IllegalStateException("nullValue needs to be castable to a Number");
        }
    }
}

