/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.factory;

import be.intersentia.elasticsearch.configuration.annotation.analyzer.Analyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CharFilter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomAnalyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomNormalizer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Filter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Property;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Tokenizer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisFactory {
    private static final Logger log = LogManager.getLogger(AnalysisFactory.class);

    public static Map<String, ?> createAnalysis(Class<?> clazz) {
        log.info("Creating ElasticSearch analysis for " + clazz.getSimpleName());
        log.trace(clazz.getSimpleName() + ": Inspecting annotations");
        HashMap<String, Object> map = new HashMap<String, Object>();
        AnalysisFactory.createConfiguration(map, (CharFilter[])clazz.getAnnotationsByType(CharFilter.class));
        AnalysisFactory.createConfiguration(map, (Tokenizer[])clazz.getAnnotationsByType(Tokenizer.class));
        AnalysisFactory.createConfiguration(map, (Filter[])clazz.getAnnotationsByType(Filter.class));
        AnalysisFactory.createConfiguration(map, (Analyzer[])clazz.getAnnotationsByType(Analyzer.class), (CustomAnalyzer[])clazz.getAnnotationsByType(CustomAnalyzer.class));
        AnalysisFactory.createConfiguration(map, (CustomNormalizer[])clazz.getAnnotationsByType(CustomNormalizer.class));
        ByteArrayOutputStream is = new ByteArrayOutputStream();
        if (log.isDebugEnabled()) {
            PrintStream stream = new PrintStream(is);
            MapUtils.verbosePrint((PrintStream)stream, (Object)clazz.getSimpleName(), map);
            stream.close();
            log.debug("Returning analysis for " + is.toString());
        }
        return Collections.singletonMap("analysis", map);
    }

    private static void createConfiguration(Map<String, Object> parentMap, CharFilter[] charFilters) {
        if (charFilters.length > 0) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            for (CharFilter charFilter : charFilters) {
                map.put(charFilter.name(), AnalysisFactory.createConfiguration(charFilter.type(), charFilter.properties()));
            }
            parentMap.put("char_filter", map);
        }
    }

    private static void createConfiguration(Map<String, Object> parentMap, Tokenizer[] tokenizers) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        for (Tokenizer tokenizer : tokenizers) {
            map.put(tokenizer.name(), AnalysisFactory.createConfiguration(tokenizer.type(), tokenizer.properties()));
        }
        parentMap.put("tokenizer", map);
    }

    private static void createConfiguration(Map<String, Object> parentMap, Filter[] filters) {
        if (filters.length > 0) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            for (Filter filter : filters) {
                map.put(filter.name(), AnalysisFactory.createConfiguration(filter.type(), filter.properties()));
            }
            parentMap.put("filter", map);
        }
    }

    private static void createConfiguration(Map<String, Object> parentMap, Analyzer[] analyzers, CustomAnalyzer[] customAnalyzers) {
        if (analyzers.length > 0 || customAnalyzers.length > 0) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            for (Analyzer analyzer : analyzers) {
                map.put(analyzer.name(), AnalysisFactory.createConfiguration(analyzer.type(), analyzer.properties()));
            }
            for (Annotation annotation : customAnalyzers) {
                HashMap<String, Object> elementMap = new HashMap<String, Object>();
                elementMap.put("char_filter", annotation.charFilters());
                elementMap.put("tokenizer", annotation.tokenizer());
                elementMap.put("filter", annotation.filters());
                elementMap.put("position_increment_gap", annotation.positionIncrementGap());
                map.put(annotation.name(), elementMap);
            }
            parentMap.put("analyzer", map);
        }
    }

    private static void createConfiguration(Map<String, Object> parentMap, CustomNormalizer[] customNormalizers) {
        if (customNormalizers.length > 0) {
            HashMap map = new HashMap();
            for (CustomNormalizer customNormalizer : customNormalizers) {
                HashMap<String, String[]> elementMap = new HashMap<String, String[]>();
                elementMap.put("char_filter", customNormalizer.charFilters());
                elementMap.put("filter", customNormalizer.filters());
                map.put(customNormalizer.name(), elementMap);
            }
            parentMap.put("normalizer", map);
        }
    }

    private static Map<String, Object> createConfiguration(String type, Property[] properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        for (Property property : properties) {
            map.put(property.key(), property.value());
        }
        return map;
    }
}

