/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration;

import be.intersentia.elasticsearch.configuration.CreateIndexResult;
import be.intersentia.elasticsearch.configuration.annotation.Index;
import be.intersentia.elasticsearch.configuration.factory.AnalysisFactory;
import be.intersentia.elasticsearch.configuration.factory.MappingFactory;
import io.github.classgraph.ClassGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationScanner {
    private static final Logger log = LogManager.getLogger(ConfigurationScanner.class);
    private Map<Index, Class<?>> indices = new HashMap();

    public static ConfigurationScanner scan(String packageName) {
        ConfigurationScanner instance = new ConfigurationScanner();
        new ClassGraph().whitelistPackages(new String[]{packageName}).enableAnnotationInfo().enableClassInfo().scan().getClassesWithAnnotation(Index.class.getName()).loadClasses().forEach(c -> {
            log.debug("Found a searchable class: " + c.getName());
            instance.indices.put(c.getAnnotation(Index.class), (Class<?>)c);
        });
        return instance;
    }

    public Set<Index> getIndices() {
        return this.indices.keySet();
    }

    public List<CreateIndexResult> configure() {
        return this.indices.entrySet().stream().map(entry -> {
            Index indexInfo = (Index)entry.getKey();
            Class clazz = (Class)entry.getValue();
            return new CreateIndexResult(indexInfo.value().equals("DEFAULT") ? clazz.getSimpleName() : indexInfo.value(), AnalysisFactory.createAnalysis(clazz), MappingFactory.createMapping(clazz, indexInfo.disableDynamicProperties(), indexInfo.parent()));
        }).collect(Collectors.toList());
    }
}

