/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser.mapping;

import be.intersentia.elasticsearch.configuration.annotation.mapping.NestedMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.NestedMappings;
import be.intersentia.elasticsearch.configuration.annotation.mapping.OptionalBoolean;
import be.intersentia.elasticsearch.configuration.factory.MappingFactory;
import be.intersentia.elasticsearch.configuration.parser.mapping.AbstractMappingParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class NestedMappingParser
extends AbstractMappingParser<NestedMapping> {
    public NestedMappingParser(Class<?> clazz, Field field, NestedMapping annotation) {
        super(clazz, field, (Annotation[])new NestedMapping[]{annotation});
    }

    public NestedMappingParser(Class<?> clazz, Field field, NestedMappings annotations) {
        super(clazz, field, (Annotation[])annotations.value());
    }

    @Override
    public String getFieldName(NestedMapping annotation) {
        return this.getFieldName(annotation, annotation.field());
    }

    @Override
    public String getMappingName(NestedMapping annotation) {
        return "DEFAULT";
    }

    @Override
    public String getType(NestedMapping annotation) {
        return "nested";
    }

    @Override
    public void addMapping(Map<String, Object> mapping, NestedMapping annotation) {
        mapping.put("dynamic", annotation.dynamic().name().toLowerCase());
        if (annotation.includeInAll() != OptionalBoolean.DEFAULT) {
            mapping.put("include_in_all", annotation.includeInAll().name().toLowerCase());
        }
        if (this.field == null) {
            mapping.put("properties", new HashMap());
        } else if (Collection.class.isAssignableFrom(this.field.getType())) {
            ParameterizedType listType = (ParameterizedType)this.field.getGenericType();
            Class listClass = (Class)listType.getActualTypeArguments()[0];
            mapping.putAll(MappingFactory.createMapping(listClass, false, false, Optional.empty(), Optional.of(this.clazz)));
        } else {
            mapping.putAll(MappingFactory.createMapping(this.field.getType(), false, false, Optional.empty(), Optional.of(this.clazz)));
        }
    }
}

