/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser.mapping;

import be.intersentia.elasticsearch.configuration.annotation.mapping.BooleanMapping;
import be.intersentia.elasticsearch.configuration.annotation.mapping.BooleanMappings;
import be.intersentia.elasticsearch.configuration.parser.mapping.AbstractMappingParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class BooleanMappingParser
extends AbstractMappingParser<BooleanMapping> {
    public BooleanMappingParser(Class<?> clazz, Field field, BooleanMapping annotation) {
        super(clazz, field, (Annotation[])new BooleanMapping[]{annotation});
    }

    public BooleanMappingParser(Class<?> clazz, Field field, BooleanMappings annotations) {
        super(clazz, field, (Annotation[])annotations.value());
    }

    @Override
    public String getFieldName(BooleanMapping annotation) {
        return this.getFieldName(annotation, annotation.field());
    }

    @Override
    public String getMappingName(BooleanMapping annotation) {
        return "DEFAULT";
    }

    @Override
    public String getType(BooleanMapping annotation) {
        return "boolean";
    }

    @Override
    public void addMapping(Map<String, Object> mapping, BooleanMapping annotation) {
        mapping.put("boost", Float.valueOf(annotation.boost()));
        if (ArrayUtils.isNotEmpty((Object[])annotation.copyTo())) {
            mapping.put("copy_to", annotation.copyTo());
        }
        mapping.put("doc_values", annotation.docValues());
        mapping.put("index", annotation.index());
        if (!"DEFAULT".equals(annotation.nullValue())) {
            mapping.put("null_value", annotation.nullValue());
        }
        mapping.put("store", annotation.store());
    }
}

