/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.parser.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMappingParser<T extends Annotation> {
    protected Class<?> clazz;
    protected Field field;
    protected List<T> annotations;

    AbstractMappingParser(Class<?> clazz, Field field, T ... annotations) {
        this.clazz = clazz;
        this.field = field;
        this.annotations = new ArrayList<T>();
        this.annotations.addAll(Arrays.asList(annotations));
    }

    public abstract String getFieldName(T var1);

    String getFieldName(T annotation, String fieldName) {
        if (!"DEFAULT".equals(fieldName)) {
            return fieldName;
        }
        if (this.field == null) {
            throw new IllegalArgumentException("Class " + this.clazz.getName() + " is annotated with an ElasticSearch " + this.getType(annotation) + " mapping without a fieldName. FieldName is only optional for method annotations");
        }
        return this.field.getName();
    }

    public abstract String getMappingName(T var1);

    public abstract String getType(T var1);

    public void addMapping(Map<String, Object> map, List<AbstractMappingParser<?>> nestedParsers, boolean isNested) {
        for (Annotation annotation : this.annotations) {
            HashMap<String, Object> annotationMap = new HashMap<String, Object>();
            annotationMap.put("type", this.getType(annotation));
            this.addMapping(annotationMap, annotation);
            if (!nestedParsers.isEmpty()) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                for (AbstractMappingParser<?> parser : nestedParsers) {
                    parser.addMapping(nestedMap, new ArrayList(), true);
                }
                annotationMap.put("fields", nestedMap);
            }
            map.put(isNested ? this.getMappingName(annotation) : this.getFieldName(annotation), annotationMap);
        }
    }

    protected abstract void addMapping(Map<String, Object> var1, T var2);

    public boolean hasDefault() {
        for (Annotation annotation : this.annotations) {
            if (!"DEFAULT".equals(this.getMappingName(annotation))) continue;
            return true;
        }
        return false;
    }
}

