/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration.factory;

import be.intersentia.elasticsearch.configuration.annotation.analyzer.Analysis;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Analyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CharFilter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomAnalyzer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.CustomNormalizer;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Filter;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Property;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Tokenizer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class AnalysisFactory {
    private static final Logger log = Logger.getLogger(AnalysisFactory.class);

    public static Map<String, ?> createAnalysis(Class<?> clazz) {
        log.info((Object)("Creating ElasticSearch analysis for " + clazz.getSimpleName()));
        Map<Object, Object> map = new HashMap();
        log.trace((Object)(clazz.getSimpleName() + ": Inspecting annotations"));
        Analysis analysis = clazz.getAnnotation(Analysis.class);
        if (analysis != null) {
            map = AnalysisFactory.createAnalysis(analysis);
        }
        ByteArrayOutputStream is = new ByteArrayOutputStream();
        if (log.isDebugEnabled()) {
            PrintStream stream = new PrintStream(is);
            MapUtils.verbosePrint((PrintStream)stream, (Object)clazz.getSimpleName(), map);
            stream.close();
            log.debug((Object)("Returning analysis for " + is.toString()));
        }
        return Collections.singletonMap("analysis", map);
    }

    private static Map<String, Object> createAnalysis(Analysis analysis) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ArrayUtils.isNotEmpty((Object[])analysis.charFilters())) {
            map.put("char_filter", AnalysisFactory.createConfiguration(analysis.charFilters()));
        }
        if (ArrayUtils.isNotEmpty((Object[])analysis.tokenizers())) {
            map.put("tokenizer", AnalysisFactory.createConfiguration(analysis.tokenizers()));
        }
        if (ArrayUtils.isNotEmpty((Object[])analysis.filters())) {
            map.put("filter", AnalysisFactory.createConfiguration(analysis.filters()));
        }
        if (ArrayUtils.isNotEmpty((Object[])analysis.analyzers()) || ArrayUtils.isNotEmpty((Object[])analysis.customAnalyzers())) {
            map.put("analyzer", AnalysisFactory.createConfiguration(analysis.analyzers(), analysis.customAnalyzers()));
        }
        if (ArrayUtils.isNotEmpty((Object[])analysis.customNormalizers())) {
            map.put("normalizer", AnalysisFactory.createConfiguration(analysis.customNormalizers()));
        }
        return map;
    }

    private static Object createConfiguration(CharFilter[] charFilters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (CharFilter charFilter : charFilters) {
            map.put(charFilter.name(), AnalysisFactory.createConfiguration(charFilter.type(), charFilter.properties()));
        }
        return map;
    }

    private static Object createConfiguration(Tokenizer[] tokenizers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Tokenizer tokenizer : tokenizers) {
            map.put(tokenizer.name(), AnalysisFactory.createConfiguration(tokenizer.type(), tokenizer.properties()));
        }
        return map;
    }

    private static Object createConfiguration(Filter[] filters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Filter filter : filters) {
            map.put(filter.name(), AnalysisFactory.createConfiguration(filter.type(), filter.properties()));
        }
        return map;
    }

    private static Object createConfiguration(Analyzer[] analyzers, CustomAnalyzer[] customAnalyzers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (analyzers != null) {
            for (Annotation annotation : analyzers) {
                map.put(annotation.name(), AnalysisFactory.createConfiguration(annotation.type(), annotation.properties()));
            }
        }
        if (customAnalyzers != null) {
            for (Annotation annotation : customAnalyzers) {
                HashMap<String, Object> elementMap = new HashMap<String, Object>();
                elementMap.put("char_filter", annotation.charFilters());
                elementMap.put("tokenizer", annotation.tokenizer());
                elementMap.put("filter", annotation.filters());
                elementMap.put("position_increment_gap", annotation.positionIncrementGap());
                map.put(annotation.name(), elementMap);
            }
        }
        return map;
    }

    private static Object createConfiguration(CustomNormalizer[] customNormalizers) {
        HashMap map = new HashMap();
        for (CustomNormalizer customNormalizer : customNormalizers) {
            HashMap<String, String[]> elementMap = new HashMap<String, String[]>();
            elementMap.put("char_filter", customNormalizer.charFilters());
            elementMap.put("filter", customNormalizer.filters());
            map.put(customNormalizer.name(), elementMap);
        }
        return map;
    }

    private static Object createConfiguration(String type, Property[] properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        for (Property property : properties) {
            map.put(property.key(), property.value());
        }
        return map;
    }
}

