/*
 * Decompiled with CFR 0.152.
 */
package be.intersentia.elasticsearch.configuration;

import be.intersentia.elasticsearch.configuration.CreateIndexResult;
import be.intersentia.elasticsearch.configuration.annotation.Index;
import be.intersentia.elasticsearch.configuration.annotation.analyzer.Analysis;
import be.intersentia.elasticsearch.configuration.factory.AnalysisFactory;
import be.intersentia.elasticsearch.configuration.factory.MappingFactory;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfigurationScanner {
    private static final Logger log = Logger.getLogger(ConfigurationScanner.class);
    final List<Class<?>> searchableClasses = new ArrayList();
    List<ClassInfo> classInfoStream = new ArrayList<ClassInfo>();
    Set<String> indices = new HashSet<String>();

    public static ConfigurationScanner scan(String namespace) {
        ConfigurationScanner me = new ConfigurationScanner();
        return me.scanNamespace(namespace);
    }

    public ConfigurationScanner scanNamespace(String namespace) {
        FastClasspathScanner scanner = new FastClasspathScanner(new String[]{namespace}).matchClassesWithAnnotation(Index.class, c -> {
            System.out.println("found a searchable-class: " + c.getName());
            this.searchableClasses.add(c);
        });
        this.classInfoStream = scanner.scan().getClassNameToClassInfo().values().stream().filter(ci -> ci.hasAnnotation(Index.class.getName())).collect(Collectors.toList());
        return this;
    }

    public List<CreateIndexResult> configure() throws Exception {
        this.classInfoStream.forEach(ci -> {
            Index s = this.getClass((ClassInfo)ci).getAnnotation(Index.class);
            this.indices.add(s.index());
        });
        return this.indices.stream().map(index -> {
            List<ClassInfo> classInfoPerForIndex = this.classInfoStream.stream().filter(ci -> {
                Index s = this.getClass((ClassInfo)ci).getAnnotation(Index.class);
                return s.index().equals(index);
            }).collect(Collectors.toList());
            CreateIndexResult request = new CreateIndexResult((String)index);
            Optional<ClassInfo> analysis = classInfoPerForIndex.stream().filter(ci -> ci.hasAnnotation(Analysis.class.getName())).findFirst();
            analysis.ifPresent(a -> request.settings(AnalysisFactory.createAnalysis(this.getClass((ClassInfo)a))));
            List parents = new ArrayList(classInfoPerForIndex).stream().filter(ci -> {
                Index s = this.getClass((ClassInfo)ci).getAnnotation(Index.class);
                return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s.parent()});
            }).map(ci -> this.getClass((ClassInfo)ci).getSimpleName()).collect(Collectors.toList());
            classInfoPerForIndex.forEach(ci -> {
                Index s = this.getClass((ClassInfo)ci).getAnnotation(Index.class);
                request.mapping(this.getClass((ClassInfo)ci).getSimpleName(), MappingFactory.createMapping(this.getClass((ClassInfo)ci), s.disableDynamicProperties(), s.disableAllField(), Optional.ofNullable(s.parent()), Optional.empty()));
            });
            return request;
        }).collect(Collectors.toList());
    }

    private Class<?> getClass(ClassInfo ci) {
        try {
            return Class.forName(ci.getClassName());
        }
        catch (Exception e) {
            log.error((Object)"cannot find class", (Throwable)e);
            return null;
        }
    }
}

