/*
 * Decompiled with CFR 0.152.
 */
package be.insaneprogramming.springboot.hajdbc;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.SimpleDatabaseClusterConfigurationFactory;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.balancer.BalancerFactory;
import net.sf.hajdbc.balancer.simple.SimpleBalancerFactory;
import net.sf.hajdbc.cache.DatabaseMetaDataCacheFactory;
import net.sf.hajdbc.cache.eager.SharedEagerDatabaseMetaDataCacheFactory;
import net.sf.hajdbc.sql.Driver;
import net.sf.hajdbc.sql.DriverDatabase;
import net.sf.hajdbc.sql.DriverDatabaseClusterConfiguration;
import net.sf.hajdbc.state.StateManagerFactory;
import net.sf.hajdbc.state.simple.SimpleStateManagerFactory;
import net.sf.hajdbc.sync.DifferentialSynchronizationStrategy;
import net.sf.hajdbc.sync.DumpRestoreSynchronizationStrategy;
import net.sf.hajdbc.sync.FastDifferentialSynchronizationStrategy;
import net.sf.hajdbc.sync.FullSynchronizationStrategy;
import net.sf.hajdbc.sync.PassiveSynchronizationStrategy;
import net.sf.hajdbc.sync.PerTableSynchronizationStrategy;
import net.sf.hajdbc.sync.TableSynchronizationStrategy;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="hajdbc")
@ConditionalOnClass(value={Driver.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Configuration
public class HaJdbcAutoConfiguration {
    private static final List<SynchronizationStrategy> SYNCHRONIZATION_STRATEGIES = Arrays.asList(new FullSynchronizationStrategy(), new DumpRestoreSynchronizationStrategy(), new DifferentialSynchronizationStrategy(), new FastDifferentialSynchronizationStrategy(), new PerTableSynchronizationStrategy((TableSynchronizationStrategy)new FullSynchronizationStrategy()), new PassiveSynchronizationStrategy());
    private boolean enabled = true;
    private List<DriverDatabase> driverDatabases;
    private String clusterName = "default";
    private String cronExpression = "0 0/1 * 1/1 * ? *";
    private String defaultSynchronizationStrategy = "full";
    boolean identityColumnDetectionEnabled = true;
    boolean sequenceDetectionEnabled = true;

    @Bean
    @ConditionalOnMissingBean
    public BalancerFactory balancerFactory() {
        return new SimpleBalancerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public StateManagerFactory stateManagerFactory() {
        return new SimpleStateManagerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseMetaDataCacheFactory databaseMetaDataCacheFactory() {
        return new SharedEagerDatabaseMetaDataCacheFactory();
    }

    @PostConstruct
    void register() throws ParseException {
        if (this.enabled) {
            DriverDatabaseClusterConfiguration config = new DriverDatabaseClusterConfiguration();
            if (this.driverDatabases == null || this.driverDatabases.size() <= 0) {
                throw new IllegalStateException("HA JDBC driver databases should be configured to contain at least one driver database");
            }
            config.setDatabases(this.driverDatabases);
            config.setDatabaseMetaDataCacheFactory(this.databaseMetaDataCacheFactory());
            config.setBalancerFactory(this.balancerFactory());
            config.setStateManagerFactory(this.stateManagerFactory());
            config.setSynchronizationStrategyMap(HaJdbcAutoConfiguration.getSynchronizationStrategyMap());
            config.setDefaultSynchronizationStrategy(this.defaultSynchronizationStrategy);
            config.setIdentityColumnDetectionEnabled(this.identityColumnDetectionEnabled);
            config.setSequenceDetectionEnabled(this.sequenceDetectionEnabled);
            config.setAutoActivationExpression(new CronExpression(this.cronExpression));
            Driver.setConfigurationFactory((String)this.clusterName, (DatabaseClusterConfigurationFactory)new SimpleDatabaseClusterConfigurationFactory((DatabaseClusterConfiguration)config));
        }
    }

    private static Map<String, SynchronizationStrategy> getSynchronizationStrategyMap() {
        HashMap<String, SynchronizationStrategy> map = new HashMap<String, SynchronizationStrategy>();
        for (SynchronizationStrategy synchronizationStrategy : SYNCHRONIZATION_STRATEGIES) {
            map.put(synchronizationStrategy.getId(), synchronizationStrategy);
        }
        return map;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<DriverDatabase> getDriverDatabases() {
        return this.driverDatabases;
    }

    public void setDriverDatabases(List<DriverDatabase> driverDatabases) {
        this.driverDatabases = driverDatabases;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getDefaultSynchronizationStrategy() {
        return this.defaultSynchronizationStrategy;
    }

    public void setDefaultSynchronizationStrategy(String defaultSynchronizationStrategy) {
        this.defaultSynchronizationStrategy = defaultSynchronizationStrategy;
    }

    public boolean isIdentityColumnDetectionEnabled() {
        return this.identityColumnDetectionEnabled;
    }

    public void setIdentityColumnDetectionEnabled(boolean identityColumnDetectionEnabled) {
        this.identityColumnDetectionEnabled = identityColumnDetectionEnabled;
    }

    public boolean isSequenceDetectionEnabled() {
        return this.sequenceDetectionEnabled;
    }

    public void setSequenceDetectionEnabled(boolean sequenceDetectionEnabled) {
        this.sequenceDetectionEnabled = sequenceDetectionEnabled;
    }
}

