/*
 * Decompiled with CFR 0.152.
 */
package be.insaneprogramming.springboot.hajdbc;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.SimpleDatabaseClusterConfigurationFactory;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.balancer.BalancerFactory;
import net.sf.hajdbc.balancer.simple.SimpleBalancerFactory;
import net.sf.hajdbc.cache.DatabaseMetaDataCacheFactory;
import net.sf.hajdbc.cache.eager.SharedEagerDatabaseMetaDataCacheFactory;
import net.sf.hajdbc.sql.Driver;
import net.sf.hajdbc.sql.DriverDatabase;
import net.sf.hajdbc.sql.DriverDatabaseClusterConfiguration;
import net.sf.hajdbc.state.StateManagerFactory;
import net.sf.hajdbc.state.simple.SimpleStateManagerFactory;
import net.sf.hajdbc.sync.DifferentialSynchronizationStrategy;
import net.sf.hajdbc.sync.DumpRestoreSynchronizationStrategy;
import net.sf.hajdbc.sync.FastDifferentialSynchronizationStrategy;
import net.sf.hajdbc.sync.FullSynchronizationStrategy;
import net.sf.hajdbc.sync.PassiveSynchronizationStrategy;
import net.sf.hajdbc.sync.PerTableSynchronizationStrategy;
import net.sf.hajdbc.sync.TableSynchronizationStrategy;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="hajdbc")
@ConditionalOnClass(value={Driver.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Configuration
public class HaJdbcAutoConfiguration {
    private static final List<SynchronizationStrategy> SYNCHRONIZATION_STRATEGIES = Arrays.asList(new FullSynchronizationStrategy(), new DumpRestoreSynchronizationStrategy(), new DifferentialSynchronizationStrategy(), new FastDifferentialSynchronizationStrategy(), new PerTableSynchronizationStrategy((TableSynchronizationStrategy)new FullSynchronizationStrategy()), new PassiveSynchronizationStrategy());
    boolean enabled = true;
    List<DriverDatabase> driverDatabases;
    String clusterName = "default";
    String cronExpression = "0 0/1 * 1/1 * ? *";
    String defaultSynchronizationStrategy = "full";
    boolean identityColumnDetectionEnabled = true;
    boolean sequenceDetectionEnabled = true;

    @Bean
    @ConditionalOnMissingBean
    public BalancerFactory balancerFactory() {
        return new SimpleBalancerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public StateManagerFactory stateManagerFactory() {
        return new SimpleStateManagerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseMetaDataCacheFactory databaseMetaDataCacheFactory() {
        return new SharedEagerDatabaseMetaDataCacheFactory();
    }

    @PostConstruct
    void register() throws ParseException {
        if (this.enabled) {
            DriverDatabaseClusterConfiguration config = new DriverDatabaseClusterConfiguration();
            if (this.driverDatabases == null || this.driverDatabases.size() <= 0) {
                throw new IllegalStateException("HA JDBC driver databases should be configured to contain at least one driver database");
            }
            config.setDatabases(this.driverDatabases);
            config.setDatabaseMetaDataCacheFactory(this.databaseMetaDataCacheFactory());
            config.setBalancerFactory(this.balancerFactory());
            config.setStateManagerFactory(this.stateManagerFactory());
            config.setSynchronizationStrategyMap(HaJdbcAutoConfiguration.getSynchronizationStrategyMap());
            config.setDefaultSynchronizationStrategy(this.defaultSynchronizationStrategy);
            config.setIdentityColumnDetectionEnabled(this.identityColumnDetectionEnabled);
            config.setSequenceDetectionEnabled(this.sequenceDetectionEnabled);
            config.setAutoActivationExpression(new CronExpression(this.cronExpression));
            Driver.setConfigurationFactory((String)this.clusterName, (DatabaseClusterConfigurationFactory)new SimpleDatabaseClusterConfigurationFactory((DatabaseClusterConfiguration)config));
        }
    }

    private static Map<String, SynchronizationStrategy> getSynchronizationStrategyMap() {
        HashMap<String, SynchronizationStrategy> map = new HashMap<String, SynchronizationStrategy>();
        for (SynchronizationStrategy synchronizationStrategy : SYNCHRONIZATION_STRATEGIES) {
            map.put(synchronizationStrategy.getId(), synchronizationStrategy);
        }
        return map;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<DriverDatabase> getDriverDatabases() {
        return this.driverDatabases;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getDefaultSynchronizationStrategy() {
        return this.defaultSynchronizationStrategy;
    }

    public boolean isIdentityColumnDetectionEnabled() {
        return this.identityColumnDetectionEnabled;
    }

    public boolean isSequenceDetectionEnabled() {
        return this.sequenceDetectionEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDriverDatabases(List<DriverDatabase> driverDatabases) {
        this.driverDatabases = driverDatabases;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setDefaultSynchronizationStrategy(String defaultSynchronizationStrategy) {
        this.defaultSynchronizationStrategy = defaultSynchronizationStrategy;
    }

    public void setIdentityColumnDetectionEnabled(boolean identityColumnDetectionEnabled) {
        this.identityColumnDetectionEnabled = identityColumnDetectionEnabled;
    }

    public void setSequenceDetectionEnabled(boolean sequenceDetectionEnabled) {
        this.sequenceDetectionEnabled = sequenceDetectionEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaJdbcAutoConfiguration)) {
            return false;
        }
        HaJdbcAutoConfiguration other = (HaJdbcAutoConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<DriverDatabase> this$driverDatabases = this.getDriverDatabases();
        List<DriverDatabase> other$driverDatabases = other.getDriverDatabases();
        if (this$driverDatabases == null ? other$driverDatabases != null : !((Object)this$driverDatabases).equals(other$driverDatabases)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        String this$defaultSynchronizationStrategy = this.getDefaultSynchronizationStrategy();
        String other$defaultSynchronizationStrategy = other.getDefaultSynchronizationStrategy();
        if (this$defaultSynchronizationStrategy == null ? other$defaultSynchronizationStrategy != null : !this$defaultSynchronizationStrategy.equals(other$defaultSynchronizationStrategy)) {
            return false;
        }
        if (this.isIdentityColumnDetectionEnabled() != other.isIdentityColumnDetectionEnabled()) {
            return false;
        }
        return this.isSequenceDetectionEnabled() == other.isSequenceDetectionEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaJdbcAutoConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<DriverDatabase> $driverDatabases = this.getDriverDatabases();
        result = result * 59 + ($driverDatabases == null ? 0 : ((Object)$driverDatabases).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 0 : $clusterName.hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 0 : $cronExpression.hashCode());
        String $defaultSynchronizationStrategy = this.getDefaultSynchronizationStrategy();
        result = result * 59 + ($defaultSynchronizationStrategy == null ? 0 : $defaultSynchronizationStrategy.hashCode());
        result = result * 59 + (this.isIdentityColumnDetectionEnabled() ? 79 : 97);
        result = result * 59 + (this.isSequenceDetectionEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "HaJdbcAutoConfiguration(enabled=" + this.isEnabled() + ", driverDatabases=" + this.getDriverDatabases() + ", clusterName=" + this.getClusterName() + ", cronExpression=" + this.getCronExpression() + ", defaultSynchronizationStrategy=" + this.getDefaultSynchronizationStrategy() + ", identityColumnDetectionEnabled=" + this.isIdentityColumnDetectionEnabled() + ", sequenceDetectionEnabled=" + this.isSequenceDetectionEnabled() + ")";
    }
}

