/*
 * Decompiled with CFR 0.152.
 */
package be.insaneprogramming.springboot.axon;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerBeanPostProcessor;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.annotation.AnnotationEventListenerBeanPostProcessor;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.fs.EventFileResolver;
import org.axonframework.eventstore.fs.FileSystemEventStore;
import org.axonframework.eventstore.fs.SimpleEventFileResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CommandBus.class})
public class AxonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    CommandBus commandBus() {
        SimpleCommandBus bus = new SimpleCommandBus();
        return bus;
    }

    @Bean
    @ConditionalOnMissingBean
    CommandGateway commandGateway() {
        DefaultCommandGateway gateway = new DefaultCommandGateway(this.commandBus(), new CommandDispatchInterceptor[0]);
        return gateway;
    }

    @Bean
    @ConditionalOnMissingBean
    EventBus eventBus() {
        SimpleEventBus bus = new SimpleEventBus();
        return bus;
    }

    @Bean
    @ConditionalOnMissingBean
    EventStore eventStore() throws IOException {
        File tempDir = Files.createTempDirectory("axon_events", new FileAttribute[0]).toFile();
        SimpleEventFileResolver resolver = new SimpleEventFileResolver(tempDir);
        FileSystemEventStore store = new FileSystemEventStore((EventFileResolver)resolver);
        return store;
    }

    @Bean
    AnnotationCommandHandlerBeanPostProcessor annotationCommandHandlerBeanPostProcessor() {
        AnnotationCommandHandlerBeanPostProcessor p = new AnnotationCommandHandlerBeanPostProcessor();
        p.setCommandBus(this.commandBus());
        return p;
    }

    @Bean
    AnnotationEventListenerBeanPostProcessor annotationEventListenerBeanPostProcessor() {
        AnnotationEventListenerBeanPostProcessor p = new AnnotationEventListenerBeanPostProcessor();
        p.setEventBus(this.eventBus());
        return p;
    }
}

