/*
 * Decompiled with CFR 0.152.
 */
package be.ida_mediafoundry.jetpack.carve.resource;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

public class ResolverClosure<T> {
    private static final String SERVICE_ACCOUNT_IDENTIFIER = "jetpack-carve-service";
    private Function<ResourceResolver, T> function;
    private ResourceResolverFactory resourceResolverFactory;

    public ResolverClosure(ResourceResolverFactory resourceResolverFactory, Function<ResourceResolver, T> function) {
        this.function = function;
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public T execute() throws LoginException {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(ResolverClosure.getAuthenticationInfo());){
            T t = this.function.apply(resourceResolver);
            return t;
        }
    }

    private static Map<String, Object> getAuthenticationInfo() {
        return Collections.singletonMap("sling.service.subservice", SERVICE_ACCOUNT_IDENTIFIER);
    }
}

