/*
 * Decompiled with CFR 0.152.
 */
package be.ida_mediafoundry.jetpack.carve.manager.util;

import be.ida_mediafoundry.jetpack.carve.annotations.CarveId;
import be.ida_mediafoundry.jetpack.carve.manager.exception.PersistorException;
import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.models.annotations.Model;

public class ModelManagerUtil {
    public static boolean isModel(Object model) {
        Class<?> clazz = model.getClass();
        return Arrays.stream(clazz.getDeclaredAnnotations()).anyMatch(annotation -> Model.class.equals(annotation.annotationType()));
    }

    public static String getCollectionPath(Class clazz) {
        return Optional.of(clazz).map(Class::getSimpleName).map(simpleName -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, simpleName)).map(simpleName -> String.format("%s/%s", "/etc/carve/models", simpleName)).orElse(null);
    }

    public static boolean isValue(Field field) {
        return field.getType().equals(String.class) || ClassUtils.isPrimitiveOrWrapper(field.getType()) || field.getType().equals(Date.class) || field.getType().equals(Calendar.class);
    }

    public static boolean canStoreInMultiValueProperty(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType aType = (ParameterizedType)field.getGenericType();
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            Class fieldArgClass = (Class)fieldArgTypes[0];
            return ClassUtils.isPrimitiveOrWrapper((Class)fieldArgClass) || fieldArgClass.equals(String.class);
        }
        return false;
    }

    public static String getCarveId(Object model) throws IllegalAccessException, PersistorException {
        Class<?> modelClass = model.getClass();
        for (Field field : modelClass.getDeclaredFields()) {
            Annotation[] annotations = field.getDeclaredAnnotations();
            boolean found = Arrays.stream(annotations).anyMatch(annotation -> annotation instanceof CarveId);
            if (!found || !field.getType().isAssignableFrom(String.class)) continue;
            field.setAccessible(true);
            return (String)field.get(model);
        }
        throw new PersistorException("Unable to find the SeriazableId annotation. Did you forget to add it?");
    }
}

