/*
 * Decompiled with CFR 0.152.
 */
package be.ida_mediafoundry.jetpack.carve.manager.serializer.impl;

import be.ida_mediafoundry.jetpack.carve.manager.serializer.Serializer;
import be.ida_mediafoundry.jetpack.carve.manager.serializer.exception.SerializerException;
import be.ida_mediafoundry.jetpack.carve.manager.validator.FieldValidator;
import be.ida_mediafoundry.jetpack.carve.manager.validator.exception.ValidationException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Named;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSerializerImpl
implements Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSerializerImpl.class);
    private final Field field;

    public SimpleSerializerImpl(Field field) throws ValidationException {
        FieldValidator.isValid(field);
        this.field = field;
    }

    private static Object getValue(Field field, Object model) {
        try {
            return field.get(model);
        }
        catch (IllegalAccessException e) {
            throw new SerializerException(String.format("Failed to read the value of field %s", field.getName()), e);
        }
    }

    @Override
    public void serialize(Resource resource, Object model) {
        String propertyName = this.getPropertyName();
        Object value = SimpleSerializerImpl.getValue(this.field, model);
        if (value != null) {
            ModifiableValueMap modifiableValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            modifiableValueMap.put((Object)propertyName, value);
        } else {
            LOG.warn("The value for field {} was null and thus not serialized.", (Object)this.field.getName());
        }
    }

    @Override
    public void serializeMultiValue(Resource resource, Object model) {
        try {
            Object[] values = ((Collection)this.field.get(model)).toArray();
            ModifiableValueMap modifiableValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            modifiableValueMap.put((Object)this.field.getName(), (Object)values);
        }
        catch (IllegalAccessException e) {
            LOG.error("Can't convert collection to array");
        }
    }

    private String getPropertyName() {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(Named.class)).map(Named::value).orElse(this.field.getName());
    }
}

