/*
 * Decompiled with CFR 0.152.
 */
package be.ida_mediafoundry.jetpack.carve.manager.impl.function;

import be.ida_mediafoundry.jetpack.carve.annotations.CarveId;
import be.ida_mediafoundry.jetpack.carve.manager.exception.ModelManagerException;
import be.ida_mediafoundry.jetpack.carve.manager.exception.PersistorException;
import be.ida_mediafoundry.jetpack.carve.manager.impl.function.ManagerFunction;
import be.ida_mediafoundry.jetpack.carve.manager.serializer.impl.SimpleSerializerImpl;
import be.ida_mediafoundry.jetpack.carve.manager.util.ModelManagerUtil;
import be.ida_mediafoundry.jetpack.carve.manager.validator.FieldValidator;
import be.ida_mediafoundry.jetpack.carve.manager.validator.ModelValidator;
import be.ida_mediafoundry.jetpack.carve.manager.validator.exception.ValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistorFunction
extends ManagerFunction
implements Function<ResourceResolver, Object> {
    private static final String MSG_CAN_NOT_SERIALIZE_MODEL = "Can not serialize model.";
    private static final String MSG_CAN_NOT_AUTHENTICATE = "Can not authenticate, the user mappings are not configured correctly.";
    public static final String MSG_SERIALIZABLE_ID_NOT_FOUND = "Unable to find the SeriazableId annotation. Did you forget to add it?";
    private static final Logger LOG = LoggerFactory.getLogger(PersistorFunction.class);
    private final Object model;
    private final String parentResourcePath;
    private final String resourceName;

    public PersistorFunction(Object model, String parentResourcePath, String resourceName) throws ValidationException {
        ModelValidator.validate(model);
        this.model = model;
        this.parentResourcePath = parentResourcePath;
        this.resourceName = resourceName;
    }

    public PersistorFunction(Object model) throws ValidationException {
        ModelValidator.validate(model);
        this.model = model;
        this.parentResourcePath = PersistorFunction.getLocation(model.getClass());
        this.resourceName = null;
    }

    private static String determineChildResourceName(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        return Arrays.stream(annotations).filter(annotation -> annotation instanceof ChildResource).findFirst().map(annotation -> ((ChildResource)annotation).name()).orElse(null);
    }

    private static Resource getOrCreateModelResource(Object model, String parentResourcePath, String resourceName, ResourceResolver resolver) throws IllegalAccessException, PersistenceException, PersistorException, ModelManagerException {
        String relativeResourcePath = resourceName;
        if (resourceName == null) {
            String id = ModelManagerUtil.getCarveId(model);
            relativeResourcePath = PersistorFunction.getPathPolicy(model.getClass()).apply(id);
        }
        String currentResourcePath = parentResourcePath + "/" + relativeResourcePath;
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)currentResourcePath, (String)"/apps/jetpack/carve/model", (String)"/apps/jetpack/carve/collection", (boolean)true);
    }

    @Override
    public Object apply(ResourceResolver resourceResolver) {
        try {
            Resource resource = PersistorFunction.getOrCreateModelResource(this.model, this.parentResourcePath, this.resourceName, resourceResolver);
            ModifiableValueMap modifiableValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            modifiableValueMap.put((Object)"jcr:primaryType", (Object)"nt:unstructured");
            for (Field field : this.model.getClass().getDeclaredFields()) {
                if (FieldValidator.isEligible(field)) {
                    field.setAccessible(true);
                    if (ModelManagerUtil.isValue(field)) {
                        this.serializeValue(resource, field);
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        this.serializeCollection(resource, field);
                        continue;
                    }
                    this.serializeField(resourceResolver, resource, field);
                    continue;
                }
                LOG.debug("Field {} is not eligible for persistence.", (Object)field.getName());
            }
            resourceResolver.commit();
        }
        catch (ModelManagerException | ValidationException | IllegalAccessException | PersistenceException e) {
            throw new PersistorException(MSG_CAN_NOT_SERIALIZE_MODEL, e);
        }
        catch (IllegalStateException e) {
            throw new PersistorException(MSG_CAN_NOT_AUTHENTICATE, e);
        }
        return this.model;
    }

    private void serializeCollection(Resource resource, Field field) throws ValidationException {
        if (ModelManagerUtil.canStoreInMultiValueProperty(field)) {
            this.storeMultiValueProperty(resource, field);
        } else {
            this.storeCollectionOfModels(resource, field);
        }
    }

    private void storeMultiValueProperty(Resource resource, Field field) throws ValidationException {
        new SimpleSerializerImpl(field).serializeMultiValue(resource, this.model);
    }

    private void storeCollectionOfModels(Resource resource, Field field) throws ValidationException {
        try {
            Object[] models;
            String containerNodePath = String.format("%s/%s", resource.getPath(), field.getName());
            ResourceUtil.getOrCreateResource((ResourceResolver)resource.getResourceResolver(), (String)containerNodePath, (String)"/apps/jetpack/carve/collection", (String)"/apps/jetpack/carve/collection", (boolean)true);
            for (Object model : models = ((Collection)field.get(this.model)).toArray()) {
                if (ModelManagerUtil.isModel(model)) {
                    new PersistorFunction(model, containerNodePath, this.determineCarveId(model)).apply(resource.getResourceResolver());
                    continue;
                }
                LOG.error("Can't persist non-annotated model in field: {}", (Object)field.getName());
            }
        }
        catch (PersistenceException e) {
            LOG.error("Couldn't create container node", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Couldn't store child in container", (Throwable)e);
        }
    }

    private String determineCarveId(Object model) {
        Field annotatedField = Arrays.stream(model.getClass().getDeclaredFields()).filter(field -> ((CarveId[])field.getAnnotationsByType(CarveId.class)).length > 0).findFirst().orElse(null);
        if (annotatedField != null) {
            try {
                annotatedField.setAccessible(true);
                return String.valueOf(annotatedField.get(model));
            }
            catch (IllegalAccessException e) {
                LOG.error("Couldnt get carveid field value", (Throwable)e);
            }
        }
        throw new PersistorException("Can't determine unique name for child model");
    }

    private void serializeField(ResourceResolver resourceResolver, Resource resource, Field field) throws ValidationException, IllegalAccessException {
        if (ModelManagerUtil.isModel(field.get(this.model))) {
            String child = PersistorFunction.determineChildResourceName(field);
            new PersistorFunction(field.get(this.model), resource.getPath(), child).apply(resourceResolver);
        } else {
            LOG.debug("Field {} is not eligible for persistence.", (Object)field.getName());
        }
    }

    private void serializeValue(Resource resource, Field field) throws ValidationException {
        new SimpleSerializerImpl(field).serialize(resource, this.model);
    }
}

