/*
 * Decompiled with CFR 0.152.
 */
package be.hobbiton.ssh.key;

import com.sun.jersey.core.util.Base64;
import java.security.InvalidKeyException;
import java.security.PublicKey;

public abstract class SshPublicKey
implements PublicKey {
    private static final long serialVersionUID = 7157529533196256497L;
    private byte[] bytes;

    public SshPublicKey(String keyString) throws SshPublicKeyException {
        if (keyString == null) {
            throw new SshPublicKeyException("Empty public key");
        }
        String[] contents = keyString.split(" ");
        if (contents.length != 3) {
            throw new SshPublicKeyException("Invalid public key");
        }
        this.bytes = Base64.decode((String)contents[1]);
    }

    @Override
    public abstract String getAlgorithm();

    protected abstract String getKeyFormat();

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    public static class SshPublicKeyException
    extends InvalidKeyException {
        private static final long serialVersionUID = 3918627693069578350L;

        public SshPublicKeyException(String message) {
            super(message);
        }
    }
}

