/*
 * Decompiled with CFR 0.152.
 */
package be.hobbiton.ssh.key;

import com.sun.jersey.core.util.Base64;
import java.security.InvalidKeyException;
import java.security.PrivateKey;

public abstract class SshPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 4323086330122037451L;
    private byte[] bytes;

    @Override
    public abstract String getAlgorithm();

    protected abstract String getKeyPrefix();

    protected abstract String getKeySuffix();

    protected SshPrivateKey(String keyString) throws SshPrivateKeyException {
        int beginIndex = keyString.indexOf(this.getKeyPrefix());
        if (beginIndex == -1) {
            throw new SshPrivateKeyException(this.getKeyPrefix() + " not found");
        }
        int endIndex = keyString.lastIndexOf(this.getKeySuffix());
        if (endIndex == -1) {
            throw new SshPrivateKeyException(this.getKeySuffix() + " not found");
        }
        String cleanKeyString = keyString.substring(beginIndex + this.getKeyPrefix().length(), endIndex).replaceAll("[\r\n]", "");
        this.bytes = Base64.decode((String)cleanKeyString);
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    public static class SshPrivateKeyException
    extends InvalidKeyException {
        private static final long serialVersionUID = 8188239961772450980L;

        public SshPrivateKeyException(String message) {
            super(message);
        }

        public SshPrivateKeyException(Throwable cause) {
            super(cause);
        }
    }
}

