/*
 * Decompiled with CFR 0.152.
 */
package be.hobbiton.ssh.key;

import java.math.BigInteger;
import java.util.Arrays;

public class Asn1Stream {
    public static final byte ASN1_INTEGER_TYPE = 2;
    public static final byte ASN1_SEQUENCE_TYPE = 48;
    private byte[] bytes;
    private int pos;

    public Asn1Stream(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            throw new ASN1EncodingException("Content should not be empty");
        }
        this.bytes = bytes;
        this.pos = 0;
    }

    public BigInteger readInteger() {
        if (this.readInt() == 2) {
            int length = this.readLength();
            if (this.pos + length > this.bytes.length) {
                throw new ASN1StreamBufferOutOfBoundsException("Unexpected end of buffer");
            }
            byte[] data = Arrays.copyOfRange(this.bytes, this.pos, this.pos + length);
            this.pos += length;
            return new BigInteger(data);
        }
        throw new UnexpectedASN1TypeException("No ASN integer");
    }

    public int readSequenceLength() {
        if (this.readInt() == 48) {
            return this.readLength();
        }
        throw new UnexpectedASN1TypeException("No ASN sequence");
    }

    private int readLength() {
        int length = this.readInt();
        if ((length & 0x80) != 0) {
            int lengthLength = length & 0x7F;
            length = 0;
            while (lengthLength-- > 0) {
                length = length << 8 | this.readInt() & 0xFF;
            }
        }
        return length;
    }

    private int readInt() {
        if (this.pos < this.bytes.length) {
            return this.bytes[this.pos++] & 0xFF;
        }
        throw new ASN1StreamBufferOutOfBoundsException("Unexpected end of buffer");
    }

    public static class UnexpectedASN1TypeException
    extends ASN1EncodingException {
        private static final long serialVersionUID = -2572653978008290090L;

        public UnexpectedASN1TypeException(String message) {
            super(message);
        }
    }

    public static class ASN1StreamBufferOutOfBoundsException
    extends ASN1EncodingException {
        private static final long serialVersionUID = -2240419807132246396L;

        public ASN1StreamBufferOutOfBoundsException(String message) {
            super(message);
        }
    }

    public static class ASN1EncodingException
    extends RuntimeException {
        private static final long serialVersionUID = 3987778424770050143L;

        public ASN1EncodingException(String message) {
            super(message);
        }
    }
}

