/*
 * Decompiled with CFR 0.152.
 */
package be.hobbiton.ssh.key;

import be.hobbiton.ssh.key.SshBufferStream;
import be.hobbiton.ssh.key.SshDsaParams;
import be.hobbiton.ssh.key.SshPublicKey;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;

public class SshDsaPublicKey
extends SshPublicKey
implements DSAPublicKey {
    private static final long serialVersionUID = -6879294591125282668L;
    private static final String KEY_FORMAT = "ssh-dss";
    private DSAParams dsaParams;
    private BigInteger y;

    public SshDsaPublicKey(String keyString) throws SshPublicKey.SshPublicKeyException {
        super(keyString);
        SshBufferStream stream = new SshBufferStream(this.getEncoded());
        String keyFormat = stream.readString();
        if (!KEY_FORMAT.equals(keyFormat)) {
            throw new SshPublicKey.SshPublicKeyException("Invalid public key format");
        }
        BigInteger modulus = stream.readInteger();
        BigInteger divisor = stream.readInteger();
        BigInteger generator = stream.readInteger();
        this.y = stream.readInteger();
        this.dsaParams = new SshDsaParams(modulus, divisor, generator);
    }

    @Override
    public DSAParams getParams() {
        return this.dsaParams;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    protected String getKeyFormat() {
        return KEY_FORMAT;
    }
}

