/*
 * Decompiled with CFR 0.152.
 */
package be.hobbiton.ssh.key;

import be.hobbiton.ssh.key.Asn1Stream;
import be.hobbiton.ssh.key.SshDsaParams;
import be.hobbiton.ssh.key.SshPrivateKey;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;

public class SshDsaPrivateKey
extends SshPrivateKey
implements DSAPrivateKey {
    private static final long serialVersionUID = 5810834239555800311L;
    public static final String BEGIN_DSA_PRIVATE_KEY = "-----BEGIN DSA PRIVATE KEY-----";
    public static final String END_DSA_PRIVATE_KEY = "-----END DSA PRIVATE KEY-----";
    private DSAParams dsaParams;
    private BigInteger x;
    private BigInteger y;
    private BigInteger version;

    public SshDsaPrivateKey(String keyString) throws SshPrivateKey.SshPrivateKeyException {
        super(keyString);
        try {
            Asn1Stream stream = new Asn1Stream(this.getEncoded());
            stream.readSequenceLength();
            this.version = stream.readInteger();
            BigInteger modulus = stream.readInteger();
            BigInteger divisor = stream.readInteger();
            BigInteger generator = stream.readInteger();
            this.y = stream.readInteger();
            this.x = stream.readInteger();
            this.dsaParams = new SshDsaParams(modulus, divisor, generator);
        }
        catch (Asn1Stream.ASN1EncodingException e) {
            throw new SshPrivateKey.SshPrivateKeyException(e);
        }
    }

    @Override
    public DSAParams getParams() {
        return this.dsaParams;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    @Override
    protected String getKeyPrefix() {
        return BEGIN_DSA_PRIVATE_KEY;
    }

    @Override
    protected String getKeySuffix() {
        return END_DSA_PRIVATE_KEY;
    }
}

