/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.xdt4j.transform;

import be.hikage.xdt4j.transform.Transform;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXPathSelectionBaseTransform
extends Transform {
    private static Logger LOG = LoggerFactory.getLogger(AbstractXPathSelectionBaseTransform.class);
    protected String selectionXPathExpression;
    private final ProcessChildenStrategy processChildenStrategy;

    public AbstractXPathSelectionBaseTransform(Document workingDocument, Element transformElement, String arguments, ProcessChildenStrategy strategy) {
        super(workingDocument, transformElement, arguments);
        this.processChildenStrategy = strategy;
    }

    @Override
    protected final void applyInternal() {
        this.selectionXPathExpression = this.getSelectionQuery();
        List targetElements = this.workingDocument.selectNodes(this.selectionXPathExpression);
        if (!targetElements.isEmpty()) {
            this.processSelection(targetElements);
        } else {
            LOG.warn("XPath {} don't match in working document, cannot process", (Object)this.selectionXPathExpression);
        }
    }

    protected void processSelection(List<Element> targetElements) {
        if (this.processChildenStrategy == ProcessChildenStrategy.FIRST) {
            this.processElement(targetElements.get(0));
        } else {
            for (Element element : targetElements) {
                this.processElement(element);
            }
        }
    }

    protected abstract void processElement(Element var1);

    protected abstract String getSelectionQuery();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcessChildenStrategy {
        FIRST,
        EACH;

    }
}

