/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.xdt4j.locator;

import be.hikage.xdt4j.XdtException;
import be.hikage.xdt4j.locator.ConditionLocator;
import be.hikage.xdt4j.locator.Locator;
import be.hikage.xdt4j.locator.MatchLocator;
import be.hikage.xdt4j.locator.XPathLocator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocatorFactory {
    private static Logger LOG = LoggerFactory.getLogger(LocatorFactory.class);
    private static final Pattern LOCATOR_VALIDATOR_PATTERN = Pattern.compile("(\\w*)(\\((.*)\\))?");

    public static final Locator createLocator(Element element) {
        String locatorAttributeValue = element.attributeValue("Locator", null);
        if (locatorAttributeValue == null) {
            return null;
        }
        Matcher locatorMatcher = LocatorFactory.extractArgumentAndValidate(locatorAttributeValue);
        String locatorType = locatorMatcher.group(1);
        String locatorParameter = locatorMatcher.group(3);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locator Type :  {}", (Object)locatorType);
            LOG.debug("Locator Parameter : {}", (Object)locatorParameter);
        }
        return LocatorFactory.instantiateImplementation(locatorType, locatorParameter);
    }

    private static Locator instantiateImplementation(String locatorType, String locatorParameter) {
        if ("Condition".equals(locatorType)) {
            return new ConditionLocator(locatorParameter);
        }
        if ("Match".equals(locatorType)) {
            return new MatchLocator(locatorParameter);
        }
        if ("XPath".equals(locatorType)) {
            return new XPathLocator(locatorParameter);
        }
        return null;
    }

    private static Matcher extractArgumentAndValidate(String locatorAttributeValue) {
        Matcher locatorMatcher = LOCATOR_VALIDATOR_PATTERN.matcher(locatorAttributeValue);
        if (!locatorMatcher.matches()) {
            throw new XdtException("The Transform Attributes value is invalid " + locatorAttributeValue);
        }
        return locatorMatcher;
    }
}

