/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.xdt4j.locator;

import be.hikage.xdt4j.locator.Locator;
import be.hikage.xdt4j.locator.LocatorFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocatorUtils {
    private static Logger LOG = LoggerFactory.getLogger(LocatorUtils.class);

    public static String generateSpecificXPath(Element currentElement) {
        ArrayList<String> xpathParts = new ArrayList<String>();
        while (currentElement != null) {
            Locator locator = LocatorFactory.createLocator(currentElement);
            if (locator != null) {
                String currentNode = currentElement.getPath(currentElement.getParent());
                xpathParts.add(currentNode + locator.generateCondition(currentElement));
            } else {
                xpathParts.add(currentElement.getPath(currentElement.getParent()));
            }
            currentElement = currentElement.getParent();
        }
        String resultXPath = Joiner.on((String)"/").join((Iterable)Lists.reverse(xpathParts));
        LOG.debug("XPath outcome of Locators processing : {}", (Object)resultXPath);
        return resultXPath;
    }
}

