/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.xdt4j;

import be.hikage.xdt4j.transform.Transform;
import be.hikage.xdt4j.transform.XdtTransformFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdtTransformer {
    private static Logger LOG = LoggerFactory.getLogger(XdtTransformer.class);

    public Document transform(Document inputDocument, Document transformDocument) {
        XPath xPath = DocumentHelper.createXPath((String)"//*[@xdt:Transform]");
        xPath.setNamespaceURIs(Collections.singletonMap("xdt", "http://schemas.microsoft.com/XML-Document-Transform"));
        Document workingCopy = (Document)inputDocument.clone();
        List xdtNode = xPath.selectNodes((Object)transformDocument);
        ArrayList<Transform> transformToApply = new ArrayList<Transform>();
        if (LOG.isInfoEnabled()) {
            LOG.info("Found {} elements to process", (Object)xdtNode.size());
        }
        for (Element xdtElement : xdtNode) {
            transformToApply.add(XdtTransformFactory.createTransform(xdtElement, workingCopy));
        }
        for (Transform tr : transformToApply) {
            tr.apply();
        }
        return workingCopy;
    }
}

