/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.maven.plugin.xmlmerge.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class Dom4JUtils {
    public static Document readDocument(URL file, StringBuilder prologBuffer) throws DocumentException, IOException {
        try {
            SAXReader reader = new SAXReader();
            return reader.read(file.openStream());
        }
        catch (DocumentException e) {
            if (e.getMessage().contains("Content is not allowed in prolog") && prologBuffer != null) {
                String xmlText = IOUtils.toString((InputStream)file.openStream());
                int firstXmlCharIndex = xmlText.indexOf("<");
                if (firstXmlCharIndex == -1) {
                    throw e;
                }
                prologBuffer.append(xmlText.substring(0, firstXmlCharIndex - 1));
                SAXReader reader = new SAXReader();
                return reader.read((Reader)new StringReader(xmlText.substring(firstXmlCharIndex)));
            }
            throw e;
        }
    }

    public static Document readDocument(URL stream) throws DocumentException, IOException {
        return Dom4JUtils.readDocument(stream, null);
    }
}

