/*
 * Decompiled with CFR 0.152.
 */
package be.hikage.maven.plugin.xmlmerge;

import be.hikage.maven.plugin.xmlmerge.XmlMerger;
import be.hikage.maven.plugin.xmlmerge.utils.Dom4JUtils;
import be.hikage.maven.plugin.xmlmerge.utils.PathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeXmlMojo
extends AbstractMojo {
    private File inputDirectory;
    private File baseDirectory;
    private File outputDirectory;
    private Boolean removeMergeDocumentAfterProcessing;
    private XmlMerger xmlMerger;
    private Boolean processProlog;
    private String mergeFilenamePattern;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("EXECUTE on " + this.outputDirectory.getAbsolutePath()));
        this.getLog().info((CharSequence)("Process prolog : " + this.processProlog));
        ArrayList<File> xmlFiles = new ArrayList<File>();
        Pattern regex = Pattern.compile(this.mergeFilenamePattern);
        this.getLog().info((CharSequence)("Search file that match " + this.mergeFilenamePattern));
        this.findXmlToMerge(this.inputDirectory, xmlFiles);
        this.getLog().info((CharSequence)("Number of file found to merge :" + xmlFiles.size()));
        try {
            for (File fileToMerge : xmlFiles) {
                Matcher matcher = regex.matcher(fileToMerge.getName());
                if (matcher.matches() && matcher.groupCount() == 2) {
                    String baseFileName = matcher.group(2);
                    File basefile = this.getBaseFile(fileToMerge, baseFileName);
                    File outputFile = this.getOutputFile(fileToMerge, baseFileName);
                    this.getLog().debug((CharSequence)("Merge Base :" + basefile.getAbsolutePath()));
                    this.getLog().debug((CharSequence)("Merge Transform :" + fileToMerge.getAbsolutePath()));
                    this.getLog().debug((CharSequence)("Merge Output :" + outputFile.getAbsolutePath()));
                    if (basefile.exists()) {
                        boolean fileDeleted;
                        StringBuilder prologHeader = this.processProlog != false ? new StringBuilder() : null;
                        Document documentBase = Dom4JUtils.readDocument(basefile.toURI().toURL(), prologHeader);
                        Document result = this.xmlMerger.mergeXml(documentBase, this.loadXml(fileToMerge));
                        this.writeMergedXml(outputFile, result, prologHeader);
                        if (!this.removeMergeDocumentAfterProcessing.booleanValue() || (fileDeleted = fileToMerge.delete())) continue;
                        this.getLog().warn((CharSequence)("Unable to delete file :" + fileToMerge.getAbsolutePath()));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("No filebase found for " + fileToMerge.getAbsolutePath()));
                    continue;
                }
                throw new MojoExecutionException("The file do not matches regex");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to merge xml", e);
        }
    }

    private File getBaseFile(File fileToMerge, String baseFileName) {
        String relativePath = PathUtils.getRelativePath(fileToMerge, this.inputDirectory).replace(fileToMerge.getName(), "");
        File baseFile = new File(this.baseDirectory, relativePath + baseFileName);
        return baseFile;
    }

    private File getOutputFile(File fileToMerge, String baseFileName) {
        String relativePath = PathUtils.getRelativePath(fileToMerge, this.inputDirectory).replace(fileToMerge.getName(), "");
        File outputFile = new File(this.outputDirectory, relativePath + baseFileName);
        return outputFile;
    }

    protected void findXmlToMerge(File fileToProcess, List<File> xmlFiles) {
        RegexFileFilter filter2 = new RegexFileFilter(this.mergeFilenamePattern);
        Collection filesFound = FileUtils.listFiles((File)fileToProcess, (IOFileFilter)filter2, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        xmlFiles.addAll(filesFound);
    }

    private Document loadXml(File baseFile) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(baseFile);
    }

    private void deleteMergeFile(File fileToMerge) {
        fileToMerge.delete();
    }

    private void writeMergedXml(File baseFile, Document base, StringBuilder prologHeader) throws IOException {
        FileOutputStream fos = new FileOutputStream(baseFile);
        if (this.processProlog.booleanValue() && prologHeader != null && StringUtils.isNotEmpty((String)prologHeader.toString())) {
            fos.write(prologHeader.toString().getBytes());
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(true);
        format.setNewLineAfterDeclaration(false);
        XMLWriter writer = new XMLWriter((OutputStream)fos, format);
        writer.write(base);
        writer.flush();
        writer.close();
    }
}

