/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);

    public static void removeDirectory(FTPClient ftpClient, String parentDir, String currentDir) throws IOException {
        FTPFile[] subFiles;
        String dirToList = parentDir;
        if (!currentDir.equals("")) {
            dirToList = dirToList + "/" + currentDir;
        }
        if ((subFiles = ftpClient.listFiles(dirToList)) != null && subFiles.length > 0) {
            for (FTPFile aFile : subFiles) {
                String currentFileName = aFile.getName();
                if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                String filePath = null;
                filePath = currentDir.equals("") ? parentDir + "/" + currentFileName : parentDir + "/" + currentDir + "/" + currentFileName;
                if (aFile.isDirectory()) {
                    FtpUtil.removeDirectory(ftpClient, dirToList, currentFileName);
                    continue;
                }
                boolean deleted = ftpClient.deleteFile(filePath);
                if (deleted) {
                    logger.info("DELETED the file: " + filePath);
                    continue;
                }
                logger.info("CANNOT delete the file: " + filePath);
            }
            boolean removed = ftpClient.removeDirectory(dirToList);
            if (removed) {
                logger.info("REMOVED the directory: " + dirToList);
            } else {
                logger.info("CANNOT remove the directory: " + dirToList);
            }
        }
    }
}

