/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.datasource;

import io.dropwizard.db.ManagedDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JEEManagedDataSource
implements ManagedDataSource {
    private DataSource jeeDatasource;

    public JEEManagedDataSource(String datasourcesJndiKey, String dataSourceName) throws NamingException {
        Context envCtx = null;
        if (datasourcesJndiKey != null) {
            InitialContext ic = new InitialContext();
            envCtx = (Context)ic.lookup(datasourcesJndiKey);
        } else {
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (this.runningOnWeblogic()) {
                env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            }
            envCtx = new InitialContext(env);
        }
        this.jeeDatasource = (DataSource)envCtx.lookup(dataSourceName);
    }

    private boolean runningOnWeblogic() {
        try {
            Class<?> weblogicServerClass = Class.forName("weblogic.Server");
            return weblogicServerClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.jeeDatasource.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.jeeDatasource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.jeeDatasource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.jeeDatasource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.jeeDatasource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.jeeDatasource.getLoginTimeout();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.jeeDatasource.getParentLogger();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.jeeDatasource.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.jeeDatasource.isWrapperFor(iface);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

