/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.config;

import be.fluid_it.tools.dropwizard.box.config.ConfigurationBridge;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.Configuration;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.File;
import java.io.IOException;
import javax.validation.Validator;

public class BridgedConfigurationFactory<T extends Configuration>
extends ConfigurationFactory<T> {
    private ConfigurationBridge<T> configurationBridge;

    public BridgedConfigurationFactory(ConfigurationBridge bridge, Class<T> klass, Validator validator, ObjectMapper objectMapper, String propertyPrefix) {
        super(klass, validator, objectMapper, propertyPrefix);
        this.configurationBridge = bridge;
    }

    public T build(File file) throws IOException, ConfigurationException {
        Configuration configuration = (Configuration)super.build(file);
        this.configurationBridge.load(configuration);
        return (T)configuration;
    }

    public T build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
        Configuration configuration = (Configuration)super.build(provider, path);
        this.configurationBridge.load(configuration);
        return (T)configuration;
    }

    public T build() throws IOException, ConfigurationException {
        Configuration configuration = (Configuration)super.build();
        this.configurationBridge.load(configuration);
        return (T)configuration;
    }
}

