/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.bridge;

import be.fluid_it.tools.dropwizard.box.WebApplication;
import be.fluid_it.tools.dropwizard.box.bridge.JEEBridge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Environment;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="bridge")
public class JEEBridgeFactory
extends SimpleServerFactory
implements ServerFactory {
    private Logger logger = LoggerFactory.getLogger(JEEBridgeFactory.class);
    @NotNull
    private String[] servletsMappedFromRootContext = new String[0];

    @JsonProperty
    public String[] getServletsMappedFromRootContext() {
        return this.servletsMappedFromRootContext;
    }

    @JsonProperty
    public void setServletsMappedFromRootContext(String[] servletsMappedFromRootContext) {
        this.servletsMappedFromRootContext = servletsMappedFromRootContext;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Server build(Environment environment) {
        JEEBridge server = new JEEBridge(environment, this.createThreadPool(environment.metrics()));
        environment.getAdminContext().setContextPath(this.getAdminContextPath());
        Handler adminHandler = this.createAdminServlet(server, environment.getAdminContext(), environment.metrics(), environment.healthChecks());
        this.registerOnJEEServletContext(this.getAdminContextPath(), adminHandler);
        environment.getApplicationContext().setContextPath(this.getApplicationContextPath());
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        this.registerOnJEEServletContext(this.getApplicationContextPath(), applicationHandler);
        return server;
    }

    protected ThreadPool createThreadPool(MetricRegistry metricRegistry) {
        int minThreads = 1;
        int maxThreads = 4;
        BlockingArrayQueue queue = new BlockingArrayQueue(minThreads, maxThreads, this.getMaxQueuedRequests());
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, maxThreads, minThreads, (int)this.getIdleThreadTimeout().toMilliseconds(), (BlockingQueue)queue);
        threadPool.setName("dw-in-a-box");
        return threadPool;
    }

    private void registerOnJEEServletContext(String contextPath, Handler jettyHandler) {
        Handler handler = jettyHandler instanceof InstrumentedHandler ? ((InstrumentedHandler)jettyHandler).getHandler() : jettyHandler;
        if (handler instanceof ServletContextHandler) {
            FilterHolder[] filters;
            FilterMapping[] filterMappings;
            ServletHolder[] servlets;
            ServletMapping[] servletMappings;
            ServletContextHandler servletContextHandler = (ServletContextHandler)handler;
            Map servletContextInitParameters = servletContextHandler.getInitParams();
            for (Map.Entry entry : servletContextInitParameters.entrySet()) {
                this.logger.info("ServletContext init parameter [" + (String)entry.getKey() + "->" + (String)entry.getValue() + "] detected ...");
                WebApplication.servletContext().setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
            for (ServletMapping servletMapping : servletMappings = servletContextHandler.getServletHandler().getServletMappings()) {
                String servletName = servletMapping.getServletName();
                String[] servletPathSpecs = servletMapping.getPathSpecs();
                this.logger.info("Servlet mapping [" + servletName + "->" + this.print(this.isContextPrefixed(servletName) ? this.prefixedPathSpecs(contextPath, servletPathSpecs) : servletPathSpecs) + "] detected ...");
            }
            block4: for (ServletHolder servletHolder : servlets = servletContextHandler.getServletHandler().getServlets()) {
                String servletName = servletHolder.getName();
                this.logger.info("Servlet [" + servletName + "] detected ...");
                try {
                    ServletRegistration.Dynamic servletRegistration = WebApplication.servletContext().addServlet(servletName, servletHolder.getServlet());
                    for (Map.Entry entry : servletHolder.getInitParameters().entrySet()) {
                        this.logger.info("Servlet init parameter [" + (String)entry.getKey() + "->" + (String)entry.getValue() + "] detected ...");
                        servletRegistration.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (servletHolder.isAsyncSupported()) {
                        servletRegistration.setAsyncSupported(true);
                    }
                    for (ServletMapping servletMapping : servletMappings) {
                        if (!servletName.equals(servletMapping.getServletName())) continue;
                        String[] servletPathSpecs = servletMapping.getPathSpecs();
                        servletRegistration.addMapping(this.isContextPrefixed(servletName) ? this.prefixedPathSpecs(contextPath, servletPathSpecs) : servletPathSpecs);
                        continue block4;
                    }
                }
                catch (ServletException e) {
                    throw new RuntimeException(e);
                }
            }
            for (FilterMapping filterMapping : filterMappings = servletContextHandler.getServletHandler().getFilterMappings()) {
                this.logger.info("Filter mapping [" + filterMapping.getFilterName() + "->" + this.print(this.prefixedPathSpecs(contextPath, filterMapping.getPathSpecs())) + "] detected ...");
            }
            for (FilterHolder filterHolder : filters = servletContextHandler.getServletHandler().getFilters()) {
                String filterName = filterHolder.getName();
                this.logger.info("Filter [" + filterName + "] detected ...");
                FilterRegistration.Dynamic filterRegistration = null;
                filterRegistration = filterHolder.getFilter() != null ? WebApplication.servletContext().addFilter(filterName, filterHolder.getFilter()) : WebApplication.servletContext().addFilter(filterName, filterHolder.getHeldClass());
                if (filterHolder.isAsyncSupported()) {
                    filterRegistration.setAsyncSupported(true);
                }
                for (Map.Entry entry : filterHolder.getInitParameters().entrySet()) {
                    this.logger.info("Filter init parameter [" + (String)entry.getKey() + "->" + (String)entry.getValue() + "] detected ...");
                    filterRegistration.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                for (FilterMapping filterMapping : filterMappings) {
                    if (!filterName.equals(filterMapping.getFilterName())) continue;
                    filterRegistration.addMappingForUrlPatterns(null, true, this.prefixedPathSpecs(contextPath, filterMapping.getPathSpecs()));
                    break;
                }
                for (EventListener eventListener : servletContextHandler.getEventListeners()) {
                    this.logger.info("EventListener on [" + eventListener.getClass().getName() + "] detected ...");
                    WebApplication.servletContext().addListener(eventListener);
                }
            }
            ContextHandler.Context dropWizardServletContext = servletContextHandler.getServletContext();
            Enumeration names = dropWizardServletContext.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.logger.info("Attribute [" + name + "->" + dropWizardServletContext.getAttribute(name) + "] detected ...");
                WebApplication.servletContext().setAttribute(name, dropWizardServletContext.getAttribute(name));
            }
        }
    }

    private boolean isContextPrefixed(String servletName) {
        if (servletName != null) {
            for (String rootContextServletName : this.servletsMappedFromRootContext) {
                if (!servletName.equals(rootContextServletName)) continue;
                return false;
            }
        }
        return true;
    }

    private String[] prefixedPathSpecs(String contextPath, String[] pathSpecs) {
        if (pathSpecs == null) {
            return new String[]{contextPath};
        }
        String[] prefixedPathSpecs = new String[pathSpecs.length];
        for (int i = 0; i < pathSpecs.length; ++i) {
            prefixedPathSpecs[i] = contextPath + pathSpecs[i];
        }
        return prefixedPathSpecs;
    }

    private String print(String[] pathSpecs) {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        for (String pathSpec : pathSpecs) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(pathSpec);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

