/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.datasource;

import be.fluid_it.tools.dropwizard.box.config.JEEDataSourceConfiguration;
import be.fluid_it.tools.dropwizard.box.datasource.JEEManagedDataSource;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedDataSource;
import java.util.Map;
import javax.naming.NamingException;

public class JEEDataSourceFactory
extends DataSourceFactory {
    private JEEDataSourceConfiguration configuration;

    public JEEDataSourceFactory(JEEDataSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.configuration.getProperties();
    }

    public ManagedDataSource build(MetricRegistry metricRegistry, String name) {
        try {
            return new JEEManagedDataSource(this.configuration.getDatasourcesJndiKey(), this.configuration.getName());
        }
        catch (NamingException e) {
            throw new IllegalStateException("An error has occured while opening datasource " + name, e);
        }
    }
}

