/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box.bridge;

import be.fluid_it.tools.dropwizard.box.WebApplication;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEEBridge
extends Server {
    private Logger logger = LoggerFactory.getLogger(JEEBridge.class);
    private final List<Connector> connectors = new LinkedList<Connector>();
    private final Map<String, Object> attributesByName = new HashMap<String, Object>();
    private final List<Handler> handlers = new LinkedList<Handler>();
    private ServerState serverState = ServerState.STARTED;
    private final List<LifeCycle.Listener> lifeCycleListeners = new LinkedList<LifeCycle.Listener>();

    public JEEBridge(ThreadPool threadPool) {
        super(threadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector[] getConnectors() {
        List<Connector> list = this.connectors;
        synchronized (list) {
            return this.connectors.toArray(new Connector[this.connectors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        List<Connector> list = this.connectors;
        synchronized (list) {
            this.connectors.add(connector);
        }
    }

    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        Map<String, Object> map = this.attributesByName;
        synchronized (map) {
            this.attributesByName.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Map<String, Object> map = this.attributesByName;
        synchronized (map) {
            return this.attributesByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        Map<String, Object> map = this.attributesByName;
        synchronized (map) {
            return new Vector<String>(this.attributesByName.keySet()).elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map<String, Object> map = this.attributesByName;
        synchronized (map) {
            this.attributesByName.remove(name);
        }
        WebApplication.servletContext().removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object attribute) {
        Map<String, Object> map = this.attributesByName;
        synchronized (map) {
            this.attributesByName.put(name, attribute);
        }
        WebApplication.servletContext().setAttribute(name, attribute);
    }

    public void handle(HttpChannel<?> connection) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void handleAsync(HttpChannel<?> connection) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Handler getHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler[] getHandlers() {
        List<Handler> list = this.handlers;
        synchronized (list) {
            return this.handlers.toArray(new Handler[this.handlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandler(Handler handler) {
        this.logger.info("Set handler ", (Object)handler.getClass().getName());
        List<Handler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public boolean isRunning() {
        return "STARTED".equals((Object)this.serverState);
    }

    public boolean isStarted() {
        return "STARTED".equals((Object)this.serverState);
    }

    public boolean isStarting() {
        return "STARTING".equals((Object)this.serverState);
    }

    public boolean isStopping() {
        return "STOPPING".equals((Object)this.serverState);
    }

    public boolean isStopped() {
        return "STOPPED".equals((Object)this.serverState);
    }

    public boolean isFailed() {
        return "FAILED".equals((Object)this.serverState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        List<LifeCycle.Listener> list = this.lifeCycleListeners;
        synchronized (list) {
            this.lifeCycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        List<LifeCycle.Listener> list = this.lifeCycleListeners;
        synchronized (list) {
            this.lifeCycleListeners.remove(listener);
        }
    }

    public String getState() {
        return this.serverState != null ? this.serverState.name() : null;
    }

    public long getStopTimeout() {
        return 0L;
    }

    public boolean isDumpAfterStart() {
        return false;
    }

    public boolean isDumpBeforeStop() {
        return false;
    }

    protected void doStart() throws Exception {
        this.logger.info("Start Bridged Jetty server ...");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.logger.info("Stop Bridged Jetty server ...");
        super.doStop();
    }

    private static enum ServerState {
        FAILED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

