/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.tools.dropwizard.box;

import be.fluid_it.tools.dropwizard.box.Destroyable;
import be.fluid_it.tools.dropwizard.box.config.ClasspathConfigurationSourceProvider;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public abstract class WebApplication<C extends Configuration>
extends Application<C>
implements ServletContextListener {
    private static ServletContext theServletContext;
    private final List<Destroyable> destroyables = new LinkedList<Destroyable>();
    private final Application<C> dropwizardApplication;
    private final String[] args;

    public static ServletContext servletContext() {
        return theServletContext;
    }

    public WebApplication(Application<C> dropwizardApplication, String configurationFileLocation) {
        this(dropwizardApplication, new String[]{"server", configurationFileLocation});
    }

    public WebApplication(Application<C> dropwizardApplication, String[] args) {
        this.dropwizardApplication = dropwizardApplication;
        this.args = args;
    }

    public void initialize(Bootstrap<C> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new ClasspathConfigurationSourceProvider());
        this.dropwizardApplication.initialize(bootstrap);
    }

    public String getName() {
        return this.dropwizardApplication.getName() + "-war";
    }

    public void run(C configuration, Environment environment) throws Exception {
        this.dropwizardApplication.run(configuration, environment);
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (theServletContext != null) {
            throw new IllegalStateException("Multple WebListeners extending WebApplication detected. Only one is allowed!");
        }
        theServletContext = sce.getServletContext();
        try {
            this.run(this.args);
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization of Dropwizard failed ...", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        List<Destroyable> list = this.destroyables;
        synchronized (list) {
            for (Destroyable destroyable : this.destroyables) {
                destroyable.destroy();
            }
        }
        theServletContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestroyable(Destroyable destroyable) {
        List<Destroyable> list = this.destroyables;
        synchronized (list) {
            this.destroyables.add(destroyable);
        }
    }
}

