/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.shiro.jee.authc;

import be.fluid_it.shiro.jee.authc.ContainerAuthenticationRealm;
import java.security.Principal;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAuthenticationToken
implements AuthenticationToken {
    private final Principal userPrincipal;
    private final Logger logger = LoggerFactory.getLogger(ContainerAuthenticationRealm.class);

    public ContainerAuthenticationToken(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Object getPrincipal() {
        if (this.userPrincipal != null) {
            String name = this.userPrincipal.getName();
            if (name == null) {
                this.logger.info("A principal encountered without a name");
            }
            return name;
        }
        this.logger.info("A null principal encountered in a ContainerAuthenticationToken");
        return null;
    }

    public Object getCredentials() {
        return "jee-container-authenticated";
    }
}

