/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.shiro.jee.authc;

import be.fluid_it.shiro.jee.authc.ContainerAuthenticationBridge;
import be.fluid_it.shiro.jee.authc.ContainerAuthenticationRealm;
import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAuthenticationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContainerAuthenticationRealm.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAuthenticated(request)) {
            logger.trace("Synchronize the Shiro subject bound to thread [" + Thread.currentThread().getId() + "] with the principal bound to request [" + request + "] ...");
            String message = new ContainerAuthenticationBridge().synchronizeShiroSubjectWithJEEPrincipal(request);
            if (message != null) {
                logger.info(message);
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            logger.trace("Cleaning up the thread context (including the Shiro subject)");
            ThreadContext.remove();
        }
    }

    public void destroy() {
    }

    private boolean isAuthenticated(ServletRequest request) {
        return request instanceof HttpServletRequest && ((HttpServletRequest)request).getUserPrincipal() != null;
    }

    public static void registerFilter(ServletContext servletContext) {
        FilterRegistration.Dynamic dynamic = servletContext.addFilter(ContainerAuthenticationFilter.class.getName(), ContainerAuthenticationFilter.class);
        dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
    }
}

